/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.config.sources;

import com.swirlds.base.ArgumentUtils;
import com.swirlds.common.config.sources.AbstractConfigSource;
import com.swirlds.common.config.sources.ConfigMapping;
import com.swirlds.config.api.source.ConfigSource;
import com.swirlds.logging.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MappedConfigSource
extends AbstractConfigSource {
    private static final String PROPERTY_NOT_FOUND = "Property '{}' not found in original config source";
    private static final String PROPERTY_ALREADY_DEFINED = "Property '%s' already defined";
    private static final String DUPLICATE_PROPERTY = "Property '{}' already found in original config source";
    private static final String PROPERTY_ALREADY_MAPPED = "Property '%s' has already a mapping defined";
    private static final Logger logger = LogManager.getLogger(MappedConfigSource.class);
    private final ConfigSource wrappedSource;
    private final Queue<ConfigMapping> configMappings;
    private final Map<String, String> properties;

    public MappedConfigSource(@NonNull ConfigSource wrappedSource) {
        this.wrappedSource = (ConfigSource)ArgumentUtils.throwArgNull((Object)wrappedSource, (String)"wrappedSource");
        this.configMappings = new ConcurrentLinkedQueue<ConfigMapping>();
        this.properties = new HashMap<String, String>();
    }

    public void addMapping(@NonNull String mappedName, @NonNull String originalName) {
        this.addMapping(new ConfigMapping(mappedName, originalName));
    }

    public void addMapping(@NonNull ConfigMapping configMapping) {
        ArgumentUtils.throwArgNull((Object)configMapping, (String)"configMapping");
        if (this.configMappings.stream().map(ConfigMapping::mappedName).anyMatch(m -> Objects.equals(m, configMapping.mappedName()))) {
            throw new IllegalArgumentException(PROPERTY_ALREADY_DEFINED.formatted(configMapping.mappedName()));
        }
        if (this.configMappings.stream().map(ConfigMapping::originalName).anyMatch(o -> Objects.equals(o, configMapping.originalName()))) {
            throw new IllegalArgumentException(PROPERTY_ALREADY_MAPPED.formatted(configMapping.originalName()));
        }
        this.configMappings.add(configMapping);
    }

    @Override
    @NonNull
    protected Map<String, String> getInternalProperties() {
        if (this.properties.isEmpty()) {
            Map internalProperties = this.wrappedSource.getProperties();
            HashMap mappedProperties = new HashMap();
            this.configMappings.forEach(configMapping -> {
                if (internalProperties.containsKey(configMapping.mappedName())) {
                    logger.warn(DUPLICATE_PROPERTY, (Object)configMapping.mappedName());
                } else if (!internalProperties.containsKey(configMapping.originalName())) {
                    logger.warn(PROPERTY_NOT_FOUND, (Object)configMapping.originalName());
                } else {
                    mappedProperties.put(configMapping.mappedName(), (String)internalProperties.get(configMapping.originalName()));
                    logger.debug(LogMarker.CONFIG.getMarker(), "Added config mapping: {}", configMapping);
                }
            });
            this.properties.putAll(internalProperties);
            this.properties.putAll(mappedProperties);
        }
        return Collections.unmodifiableMap(this.properties);
    }

    public int getOrdinal() {
        return this.wrappedSource.getOrdinal();
    }
}

