/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.constructable.internal;

import com.swirlds.common.Releasable;
import com.swirlds.common.constructable.ConstructableClass;
import com.swirlds.common.constructable.ConstructableRegistryException;
import com.swirlds.common.constructable.ConstructorRegistry;
import com.swirlds.common.constructable.NoArgsConstructor;
import com.swirlds.common.constructable.RuntimeConstructable;
import com.swirlds.common.constructable.URLClassLoaderWithLookup;
import com.swirlds.common.constructable.internal.ConstructableClasses;
import com.swirlds.common.constructable.internal.GenericClassConstructorPair;
import com.swirlds.common.constructable.internal.MethodWrapper;
import com.swirlds.common.utility.CommonUtils;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.NotImplementedException;

public class GenericConstructorRegistry<T>
implements ConstructorRegistry<T> {
    private static final Set<String> IGNORE_METHOD_NAMES = Set.of("$jacocoInit");
    private final Class<T> constructorType;
    private final Method constructorSignature;
    private final Map<Long, GenericClassConstructorPair<T>> constructors = new ConcurrentHashMap<Long, GenericClassConstructorPair<T>>();

    public GenericConstructorRegistry(Class<T> constructorType) {
        CommonUtils.throwArgNull(constructorType, "constructorType");
        this.constructorType = constructorType;
        if (!constructorType.isInterface()) {
            throw new IllegalArgumentException(String.format("The constructor type needs to be an interface, '%s' is not an interface", constructorType.getCanonicalName()));
        }
        this.constructorSignature = GenericConstructorRegistry.getMethod(constructorType);
        if (!RuntimeConstructable.class.isAssignableFrom(this.constructorSignature.getReturnType())) {
            throw new IllegalArgumentException("The constructor return type must extend RuntimeConstructable");
        }
    }

    @Override
    public T getConstructor(long classId) {
        GenericClassConstructorPair<T> p = this.constructors.get(classId);
        if (p == null) {
            return null;
        }
        return p.constructor();
    }

    public void registerConstructables(ConstructableClasses<?> constructableClasses, URLClassLoaderWithLookup additionalClassloader) throws ConstructableRegistryException {
        if (!constructableClasses.getConstructorType().equals(this.constructorType)) {
            throw new ConstructableRegistryException(String.format("Cannot register the constructor type %s, this registry requires %s", constructableClasses.getConstructorType().getCanonicalName(), this.constructorType.getCanonicalName()));
        }
        for (Class<RuntimeConstructable> constructable : constructableClasses.getClasses()) {
            this.registerConstructable(constructable, this.createConstructorLambda(constructable, additionalClassloader));
        }
    }

    @Override
    public void registerConstructable(Class<? extends RuntimeConstructable> aClass) throws ConstructableRegistryException {
        this.registerConstructable(aClass, this.createConstructorLambda(aClass, null));
    }

    @Override
    public void registerConstructable(Class<? extends RuntimeConstructable> aClass, T constructor) throws ConstructableRegistryException {
        GenericClassConstructorPair<T> pair = new GenericClassConstructorPair<T>(aClass, constructor);
        long classId = this.getClassId(pair);
        GenericClassConstructorPair<T> old = this.constructors.putIfAbsent(classId, pair);
        if (old != null && !old.classEquals(pair)) {
            throw new ConstructableRegistryException(String.format("Two classes ('%s' and '%s') have the same classId:%d (hex:%s). ClassId must be unique!", old.constructable().getCanonicalName(), pair.constructable().getCanonicalName(), classId, Long.toHexString(classId)));
        }
    }

    private long getClassId(GenericClassConstructorPair<T> pair) throws ConstructableRegistryException {
        T t = pair.constructor();
        if (t instanceof NoArgsConstructor) {
            NoArgsConstructor nac = (NoArgsConstructor)t;
            RuntimeConstructable obj = nac.get();
            long classId = obj.getClassId();
            if (obj instanceof Releasable) {
                try {
                    ((Releasable)((Object)obj)).release();
                }
                catch (NotImplementedException notImplementedException) {
                    // empty catch block
                }
            }
            return classId;
        }
        ConstructableClass classIdAnnotation = pair.constructable().getAnnotation(ConstructableClass.class);
        if (classIdAnnotation == null) {
            throw new ConstructableRegistryException(String.format("The class %s must have a @ConstructableClass annotation", pair.constructable().getName()));
        }
        return classIdAnnotation.value();
    }

    private T createConstructorLambda(Class<? extends RuntimeConstructable> constructable, URLClassLoaderWithLookup additionalClassloader) throws ConstructableRegistryException {
        T constructor;
        if (!this.hasRequiredConstructor(constructable)) {
            throw new ConstructableRegistryException(String.format("Cannot find appropriate constructor for class: %s", constructable.getCanonicalName()));
        }
        try {
            GenericConstructorRegistry.class.getModule().addReads(constructable.getModule());
            MethodHandles.Lookup lookup = GenericConstructorRegistry.getLookup(constructable, additionalClassloader);
            Class<?>[] params = this.constructorSignature.getParameterTypes();
            MethodHandle mh = lookup.findConstructor(constructable, MethodType.methodType(Void.TYPE, params));
            CallSite site = LambdaMetafactory.metafactory(lookup, this.constructorSignature.getName(), MethodType.methodType(this.constructorType), MethodType.methodType(this.constructorSignature.getReturnType(), params), mh, mh.type());
            constructor = this.constructorType.cast(site.getTarget().invoke());
        }
        catch (Throwable throwable) {
            throw new ConstructableRegistryException(String.format("Could not create a lambda for constructor: %s", throwable.getMessage()), throwable);
        }
        return constructor;
    }

    private static MethodHandles.Lookup getLookup(Class<? extends RuntimeConstructable> constructable, URLClassLoaderWithLookup additionalClassloader) throws ConstructableRegistryException {
        if (additionalClassloader != null && additionalClassloader.equals(constructable.getClassLoader())) {
            try {
                return additionalClassloader.getLookup();
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | RuntimeException e) {
                throw new ConstructableRegistryException("Issue while getting the MethodHandles.Lookup from URLClassLoaderWithLookup", e);
            }
        }
        return MethodHandles.lookup();
    }

    private boolean hasRequiredConstructor(Class<? extends RuntimeConstructable> constructable) {
        return Stream.of(constructable.getConstructors()).anyMatch(c -> Arrays.equals(c.getParameterTypes(), this.constructorSignature.getParameterTypes()));
    }

    private static Method getMethod(Class<?> constructorType) {
        Method[] methods = (Method[])Arrays.stream(constructorType.getDeclaredMethods()).filter(m -> !IGNORE_METHOD_NAMES.contains(m.getName())).map(MethodWrapper::new).distinct().map(MethodWrapper::method).toArray(Method[]::new);
        if (methods.length != 1) {
            throw new IllegalArgumentException(String.format("The constructor type '%s' must have exactly 1 method, but the following methods have been found:%n%s", constructorType.getName(), Arrays.stream(methods).map(m -> m.getReturnType().getSimpleName() + " " + m.getName() + "(" + Arrays.stream(m.getParameterTypes()).map(Class::getSimpleName).collect(Collectors.joining(" ")) + ")").collect(Collectors.joining("\n"))));
        }
        return methods[0];
    }
}

