/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.crypto;

import com.swirlds.common.crypto.DigestType;
import com.swirlds.common.crypto.EmptyHashValueException;
import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.exceptions.BadIOException;
import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.utility.CommonUtils;
import com.swirlds.common.utility.Mnemonics;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class Hash
implements Comparable<Hash>,
SelfSerializable,
Serializable {
    private static final int SHORT_STRING_BYTES = 4;
    public static final long CLASS_ID = -854880720348154850L;
    private static final int CLASS_VERSION = 1;
    private byte[] value;
    private DigestType digestType;

    public Hash() {
        this(DigestType.SHA_384);
    }

    public Hash(DigestType digestType) {
        this(new byte[digestType.digestLength()], digestType, true, false);
    }

    public Hash(byte[] value) {
        this(value, DigestType.SHA_384);
    }

    public Hash(byte[] value, DigestType digestType) {
        this(value, digestType, false, false);
    }

    public Hash(ByteBuffer byteBuffer, DigestType digestType) {
        this(digestType);
        byteBuffer.get(this.value);
    }

    public Hash(Hash other) {
        if (other == null) {
            throw new IllegalArgumentException("other");
        }
        this.digestType = other.digestType;
        this.value = Arrays.copyOf(other.value, other.value.length);
    }

    protected Hash(byte[] value, DigestType digestType, boolean bypassSafetyCheck, boolean shouldCopy) {
        byte[] valuePtr;
        if (value == null) {
            throw new IllegalArgumentException("value");
        }
        if (digestType == null) {
            throw new IllegalArgumentException("digestType");
        }
        if (value.length != digestType.digestLength()) {
            throw new IllegalArgumentException("value: " + value.length);
        }
        this.digestType = digestType;
        byte[] byArray = valuePtr = shouldCopy ? Arrays.copyOf(value, value.length) : value;
        if (!bypassSafetyCheck) {
            for (byte b : value) {
                if (b == 0) continue;
                this.value = value;
                return;
            }
            throw new EmptyHashValueException("Hash creation failed, hash is array of zeroes");
        }
        this.value = valuePtr;
    }

    public byte[] getValue() {
        return this.value;
    }

    public Hash copy() {
        return new Hash(this);
    }

    @Override
    public long getClassId() {
        return -854880720348154850L;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeInt(this.digestType.id());
        out.writeByteArray(this.value);
    }

    @Override
    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        DigestType digestType = DigestType.valueOf(in.readInt());
        if (digestType == null) {
            throw new BadIOException("Invalid DigestType identifier read from the stream");
        }
        this.digestType = digestType;
        this.value = in.readByteArray(digestType.digestLength());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Hash)) {
            return false;
        }
        Hash that = (Hash)obj;
        return this.digestType.id() == that.digestType.id() && Arrays.equals(this.value, that.value);
    }

    public int hashCode() {
        return (this.value[0] << 24) + (this.value[1] << 16) + (this.value[2] << 8) + this.value[3];
    }

    @Override
    public int compareTo(Hash that) {
        if (this == that) {
            return 0;
        }
        if (that == null) {
            throw new NullPointerException("that");
        }
        int ret = Integer.compare(this.digestType.id(), that.digestType.id());
        if (ret != 0) {
            return ret;
        }
        return Arrays.compare(this.value, that.value);
    }

    public String toString() {
        return this.value == null ? null : CommonUtils.hex(this.value);
    }

    public String toShortString() {
        return this.toShortString(4);
    }

    public String toShortString(int length) {
        return this.value == null ? null : CommonUtils.hex(this.value, length);
    }

    public String toMnemonic() {
        return Mnemonics.generateMnemonic(this.value, 4);
    }

    public DigestType getDigestType() {
        return this.digestType;
    }
}

