/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.formatting;

import com.swirlds.common.formatting.StringFormattingUtils;
import com.swirlds.common.formatting.TextEffect;

public enum HorizontalAlignment {
    ALIGNED_LEFT,
    ALIGNED_RIGHT,
    ALIGNED_CENTER;

    public static final char DEFAULT_PADDING = ' ';

    public String pad(String text, int width) {
        StringBuilder sb = new StringBuilder();
        this.pad(sb, text, ' ', width);
        return sb.toString();
    }

    public void pad(StringBuilder sb, String text, int width) {
        this.pad(sb, text, ' ', width);
    }

    public String pad(String text, char padding, int width) {
        StringBuilder sb = new StringBuilder();
        this.pad(sb, text, padding, width);
        return sb.toString();
    }

    public void pad(StringBuilder sb, String text, char padding, int width) {
        int textLength = TextEffect.getPrintableTextLength(text);
        if (textLength >= width) {
            sb.append(text);
            return;
        }
        switch (this) {
            case ALIGNED_LEFT: {
                sb.append(text).append(StringFormattingUtils.repeatedChar(padding, width - textLength));
                break;
            }
            case ALIGNED_RIGHT: {
                sb.append(StringFormattingUtils.repeatedChar(padding, width - textLength)).append(text);
                break;
            }
            case ALIGNED_CENTER: {
                int leftPadding = (width - textLength) / 2;
                int rightPadding = width - textLength - leftPadding;
                sb.append(StringFormattingUtils.repeatedChar(padding, leftPadding)).append(text).append(StringFormattingUtils.repeatedChar(padding, rightPadding));
            }
        }
    }
}

