/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.formatting;

import com.swirlds.common.formatting.StringFormattingUtils;
import com.swirlds.common.units.Unit;

public class UnitFormatter {
    private boolean abbreviate = true;
    private int decimalPlaces = 1;
    private boolean showUnit = true;
    private boolean showSpaceInBetween = true;
    private boolean simplify = true;
    private Long longQuantity;
    private Double doubleQuantity;
    private final Unit<?> unit;

    public UnitFormatter(long quantity, Unit<?> unit) {
        this.setQuantity(quantity);
        this.unit = unit;
    }

    public UnitFormatter(double quantity, Unit<?> unit) {
        this.setQuantity(quantity);
        this.unit = unit;
    }

    public UnitFormatter(Unit<?> unit) {
        this.setQuantity(0L);
        this.unit = unit;
    }

    public UnitFormatter setSimplify(boolean simplify) {
        this.simplify = simplify;
        return this;
    }

    public UnitFormatter setQuantity(long quantity) {
        this.doubleQuantity = null;
        this.longQuantity = quantity;
        return this;
    }

    public UnitFormatter setQuantity(double quantity) {
        this.longQuantity = null;
        this.doubleQuantity = quantity;
        return this;
    }

    public UnitFormatter setAbbreviate(boolean abbreviate) {
        this.abbreviate = abbreviate;
        return this;
    }

    public UnitFormatter setDecimalPlaces(int decimalPlaces) {
        this.decimalPlaces = decimalPlaces;
        return this;
    }

    public UnitFormatter setShowUnit(boolean showUnit) {
        this.showUnit = showUnit;
        return this;
    }

    public UnitFormatter setShowSpaceInBetween(boolean showSpaceInBetween) {
        this.showSpaceInBetween = showSpaceInBetween;
        return this;
    }

    public String render() {
        StringBuilder sb = new StringBuilder();
        this.render(sb);
        return sb.toString();
    }

    public void render(StringBuilder sb) {
        double quantity;
        Unit<?> finalUnit;
        if (this.longQuantity == null && this.doubleQuantity == null) {
            throw new IllegalStateException("Quantity must be set");
        }
        if (this.longQuantity != null && this.doubleQuantity != null) {
            throw new IllegalStateException("Quantity must be set to either long or double, not both");
        }
        if (this.simplify) {
            Unit.SimplifiedQuantity<?> simplifiedQuantity = this.longQuantity == null ? this.unit.simplify(this.doubleQuantity) : this.unit.simplify(this.longQuantity.longValue());
            finalUnit = simplifiedQuantity.unit();
            quantity = simplifiedQuantity.quantity();
        } else {
            finalUnit = this.unit;
            quantity = this.longQuantity == null ? this.doubleQuantity : (double)this.longQuantity.longValue();
        }
        String quantityString = StringFormattingUtils.commaSeparatedNumber(quantity, this.decimalPlaces);
        sb.append(quantityString);
        if (this.showUnit) {
            if (this.showSpaceInBetween) {
                sb.append(" ");
            }
            if (this.abbreviate) {
                sb.append(finalUnit.getAbbreviation());
            } else {
                boolean plural = false;
                if (quantityString.charAt(0) != '1') {
                    plural = true;
                } else if (quantityString.length() > 1) {
                    if (quantityString.charAt(1) != '.') {
                        plural = true;
                    } else {
                        for (int i = 2; i < quantityString.length(); ++i) {
                            char c = quantityString.charAt(i);
                            if (c == '0') continue;
                            plural = true;
                            break;
                        }
                    }
                }
                if (plural) {
                    sb.append(finalUnit.getPluralName());
                } else {
                    sb.append(finalUnit.getName());
                }
            }
        }
    }
}

