/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.io.utility;

import com.swirlds.common.config.StateConfig;
import com.swirlds.common.config.singleton.ConfigurationHolder;
import com.swirlds.common.io.config.TemporaryFileConfig;
import com.swirlds.common.io.utility.FileUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class TemporaryFileBuilder {
    private static long nextFileId = 0L;
    private static Path temporaryFileLocation = null;

    private TemporaryFileBuilder() {
    }

    public static synchronized Path getTemporaryFileLocation() throws IOException {
        if (temporaryFileLocation == null) {
            TemporaryFileConfig config = ConfigurationHolder.getConfigData(TemporaryFileConfig.class);
            StateConfig stateConfig = ConfigurationHolder.getConfigData(StateConfig.class);
            TemporaryFileBuilder.overrideTemporaryFileLocation(FileUtils.getAbsolutePath(config.getTemporaryFilePath(stateConfig)));
        }
        return temporaryFileLocation;
    }

    public static synchronized void overrideTemporaryFileLocation(Path newTemporaryFileLocation) throws IOException {
        temporaryFileLocation = newTemporaryFileLocation.toAbsolutePath().normalize();
        if (Files.exists(temporaryFileLocation, new LinkOption[0])) {
            FileUtils.deleteDirectoryAndLog(temporaryFileLocation);
        }
        Files.createDirectories(temporaryFileLocation, new FileAttribute[0]);
    }

    public static synchronized Path buildTemporaryFile() throws IOException {
        return TemporaryFileBuilder.buildTemporaryFile(null);
    }

    public static synchronized Path buildTemporaryFile(String postfix) throws IOException {
        String fileName = nextFileId + (String)(postfix == null ? "" : "-" + postfix);
        ++nextFileId;
        Path temporaryFile = TemporaryFileBuilder.getTemporaryFileLocation().resolve(fileName);
        if (Files.exists(temporaryFile, new LinkOption[0])) {
            throw new IOException("Name collision for temporary file " + temporaryFile);
        }
        return temporaryFile;
    }

    public static synchronized Path buildTemporaryDirectory() throws IOException {
        return TemporaryFileBuilder.buildTemporaryDirectory(null);
    }

    public static synchronized Path buildTemporaryDirectory(String postfix) throws IOException {
        Path directory = TemporaryFileBuilder.buildTemporaryFile(postfix);
        if (!Files.exists(directory, new LinkOption[0])) {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        return directory;
    }
}

