/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.copy;

import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.route.MerkleRoute;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

class NodeToCopy {
    private final MerkleInternal newParent;
    private final int indexInParent;
    private final MerkleNode nodeToCopy;
    private final MerkleNode originalNodeInSamePosition;

    public NodeToCopy(MerkleInternal newParent, int indexInParent, MerkleNode nodeToCopy, MerkleNode originalNodeInSamePosition) {
        this.newParent = newParent;
        this.indexInParent = indexInParent;
        this.nodeToCopy = nodeToCopy;
        this.originalNodeInSamePosition = originalNodeInSamePosition;
    }

    public MerkleRoute getRouteForNode() {
        if (this.originalNodeInSamePosition == null) {
            return null;
        }
        return this.originalNodeInSamePosition.getRoute();
    }

    public MerkleNode getOriginalNodeInSamePositionOfChild(int childIndex) {
        if (this.originalNodeInSamePosition == null || this.originalNodeInSamePosition.isLeaf() || this.originalNodeInSamePosition.asInternal().getNumberOfChildren() <= childIndex) {
            return null;
        }
        return this.originalNodeInSamePosition.asInternal().getChild(childIndex);
    }

    public MerkleInternal getNewParent() {
        return this.newParent;
    }

    public int getIndexInParent() {
        return this.indexInParent;
    }

    public MerkleNode getNodeToCopy() {
        return this.nodeToCopy;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("parent", (Object)this.newParent).append("index", this.indexInParent).append("node to copy", (Object)this.nodeToCopy).toString();
    }
}

