/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.impl;

import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.exceptions.IllegalChildIndexException;
import com.swirlds.common.merkle.impl.PartialMerkleInternal;
import com.swirlds.common.merkle.impl.internal.AbstractMerkleInternal;

public class PartialBinaryMerkleInternal
extends AbstractMerkleInternal
implements PartialMerkleInternal {
    private MerkleNode left;
    private MerkleNode right;
    private static final int MIN_BINARY_CHILD_COUNT = 0;
    private static final int BINARY_CHILD_COUNT = 2;

    public PartialBinaryMerkleInternal() {
    }

    protected PartialBinaryMerkleInternal(PartialBinaryMerkleInternal other) {
        super(other);
    }

    @Override
    public int getNumberOfChildren() {
        return 2;
    }

    @Override
    public int getMinimumChildCount() {
        return 0;
    }

    @Override
    public int getMaximumChildCount() {
        return 2;
    }

    @Override
    public <T extends MerkleNode> T getChild(int index) {
        if (index == 0) {
            return (T)this.left;
        }
        if (index == 1) {
            return (T)this.right;
        }
        throw new IllegalChildIndexException(0, 1, index);
    }

    @Override
    protected void setChildInternal(int index, MerkleNode child) {
        if (index == 0) {
            this.left = child;
        } else if (index == 1) {
            this.right = child;
        } else {
            throw new IllegalChildIndexException(0, 1, index);
        }
    }

    public <T extends MerkleNode> void setLeft(T left) {
        this.setChild(0, left);
    }

    public <T extends MerkleNode> T getLeft() {
        return (T)this.left;
    }

    public <T extends MerkleNode> void setRight(T right) {
        this.setChild(1, right);
    }

    public <T extends MerkleNode> T getRight() {
        return (T)this.right;
    }

    @Override
    protected void allocateSpaceForChild(int index) {
    }

    @Override
    protected void checkChildIndexIsValid(int index) {
    }

    private static class ChildIndices {
        public static final int LEFT = 0;
        public static final int RIGHT = 1;

        private ChildIndices() {
        }
    }
}

