/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.impl;

import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.exceptions.IllegalChildIndexException;
import com.swirlds.common.merkle.impl.PartialMerkleInternal;
import com.swirlds.common.merkle.impl.internal.AbstractMerkleInternal;
import java.util.ArrayList;
import java.util.List;

public class PartialNaryMerkleInternal
extends AbstractMerkleInternal
implements PartialMerkleInternal {
    private final ArrayList<MerkleNode> children;

    public PartialNaryMerkleInternal() {
        this.children = new ArrayList(Math.min(0, this.getMinimumChildCount()));
    }

    protected PartialNaryMerkleInternal(int initialSize) {
        if (initialSize > 64) {
            throw new IllegalChildIndexException(0, 64, initialSize);
        }
        this.children = new ArrayList(initialSize);
    }

    protected PartialNaryMerkleInternal(PartialNaryMerkleInternal that) {
        super(that);
        this.children = new ArrayList(that.getNumberOfChildren());
    }

    @Override
    public int getNumberOfChildren() {
        return this.children.size();
    }

    @Override
    public <T extends MerkleNode> T getChild(int index) {
        if (this.children.size() <= index || index < 0) {
            this.checkChildIndexIsValid(index);
            return null;
        }
        return (T)this.children.get(index);
    }

    @Override
    protected void setChildInternal(int index, MerkleNode child) {
        this.children.set(index, child);
    }

    @Override
    protected void allocateSpaceForChild(int index) {
        for (int i = this.children.size(); i <= index; ++i) {
            this.children.add(null);
        }
    }

    @Override
    public void addDeserializedChildren(List<MerkleNode> children, int version) {
        for (MerkleNode child : this.children) {
            if (child == null) continue;
            child.release();
        }
        this.children.clear();
        super.addDeserializedChildren(children, version);
    }

    @Override
    protected void checkChildIndexIsValid(int index) {
        int maxSize = Math.min(this.getMaximumChildCount(), 64);
        if (index < 0 || index >= maxSize) {
            throw new IllegalChildIndexException(0, maxSize - 1, index);
        }
    }
}

