/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.iterators;

import com.swirlds.common.io.utility.IOConsumer;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.iterators.MerkleIterationOrder;
import com.swirlds.common.merkle.iterators.internal.BreadthFirstAlgorithm;
import com.swirlds.common.merkle.iterators.internal.MerkleIterationAlgorithm;
import com.swirlds.common.merkle.iterators.internal.NullNode;
import com.swirlds.common.merkle.iterators.internal.PostOrderedDepthFirstAlgorithm;
import com.swirlds.common.merkle.iterators.internal.PostOrderedDepthFirstRandomAlgorithm;
import com.swirlds.common.merkle.iterators.internal.PreOrderedDepthFirstAlgorithm;
import com.swirlds.common.merkle.route.MerkleRoute;
import com.swirlds.common.threading.interrupt.InterruptableConsumer;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;

public class MerkleIterator<T extends MerkleNode>
implements Iterator<T> {
    private final MerkleNode root;
    private T next;
    private MerkleRoute nextRoute;
    private MerkleRoute previousRoute;
    private boolean hasNext;
    private BiPredicate<MerkleNode, MerkleRoute> filter;
    private Predicate<MerkleInternal> descendantFilter;
    private boolean ignoreNull = true;
    private MerkleIterationOrder order = MerkleIterationOrder.POST_ORDERED_DEPTH_FIRST;
    private MerkleIterationAlgorithm algorithm;

    public MerkleIterator(MerkleNode root) {
        this.root = root;
    }

    public MerkleIterator<T> setFilter(Predicate<MerkleNode> filter) {
        this.setFilter((MerkleNode node, MerkleRoute route) -> filter.test((MerkleNode)node));
        return this;
    }

    public MerkleIterator<T> setFilter(BiPredicate<MerkleNode, MerkleRoute> filter) {
        if (this.algorithm != null) {
            throw new IllegalStateException("iterator can not be configured after iteration has started");
        }
        this.filter = filter;
        return this;
    }

    public MerkleIterator<T> setDescendantFilter(Predicate<MerkleInternal> descendantFilter) {
        if (this.algorithm != null) {
            throw new IllegalStateException("iterator can not be configured after iteration has started");
        }
        this.descendantFilter = descendantFilter;
        return this;
    }

    public MerkleIterator<T> ignoreNull(boolean ignoreNullNodes) {
        if (this.algorithm != null) {
            throw new IllegalStateException("iterator can not be configured after iteration has started");
        }
        this.ignoreNull = ignoreNullNodes;
        return this;
    }

    public MerkleIterator<T> setOrder(MerkleIterationOrder order) {
        this.order = order;
        return this;
    }

    private boolean shouldVisitDescendants(MerkleInternal node) {
        if (this.descendantFilter != null) {
            return this.descendantFilter.test(node);
        }
        return true;
    }

    private boolean shouldNodeBeReturned(MerkleNode node, MerkleRoute route) {
        if (this.ignoreNull && node == null) {
            return false;
        }
        if (this.filter != null) {
            return this.filter.test(node, route);
        }
        return true;
    }

    private boolean hasChildrenToHandle(MerkleNode node) {
        return node != null && node.isInternal() && this.algorithm.size() > 0 && this.algorithm.peek() == node;
    }

    protected final void pushNode(MerkleInternal parent, int childIndex) {
        MerkleNode node = parent.getChild(childIndex);
        if (node == null) {
            if (!this.ignoreNull) {
                this.pushNode(new NullNode(parent.getRoute().extendRoute(childIndex)));
            }
        } else {
            this.pushNode(node);
        }
    }

    private void pushNode(MerkleNode node) {
        this.algorithm.push(node);
        if (node.isInternal() && this.shouldVisitDescendants(node.asInternal())) {
            this.algorithm.push(node);
        }
    }

    private void setup() {
        if (this.algorithm == null) {
            switch (this.order) {
                case POST_ORDERED_DEPTH_FIRST: {
                    this.algorithm = new PostOrderedDepthFirstAlgorithm();
                    break;
                }
                case POST_ORDERED_DEPTH_FIRST_RANDOM: {
                    this.algorithm = new PostOrderedDepthFirstRandomAlgorithm();
                    break;
                }
                case PRE_ORDERED_DEPTH_FIRST: {
                    this.algorithm = new PreOrderedDepthFirstAlgorithm();
                    break;
                }
                case BREADTH_FIRST: {
                    this.algorithm = new BreadthFirstAlgorithm();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unhandled iteration algorithm " + this.order);
                }
            }
            if (this.root != null) {
                this.pushNode(this.root);
            }
        }
    }

    private void findNext() {
        this.setup();
        if (this.hasNext) {
            return;
        }
        while (this.algorithm.size() > 0) {
            MerkleNode target;
            MerkleNode candidate = this.algorithm.pop();
            this.nextRoute = candidate.getRoute();
            MerkleNode merkleNode = target = candidate.getClassId() == 7299478751792064481L ? null : candidate;
            if (this.hasChildrenToHandle(target)) {
                this.algorithm.pushChildren(target.asInternal(), this::pushNode);
                continue;
            }
            if (!this.shouldNodeBeReturned(target, this.nextRoute)) continue;
            this.next = target;
            this.hasNext = true;
            return;
        }
    }

    @Override
    public final boolean hasNext() {
        this.findNext();
        return this.hasNext;
    }

    @Override
    public final T next() {
        this.findNext();
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        this.previousRoute = this.nextRoute;
        this.hasNext = false;
        return this.next;
    }

    public final MerkleRoute getRoute() {
        return this.previousRoute;
    }

    public <K> Iterator<K> transform(Function<T, K> converter) {
        return this.transform((T node, MerkleRoute route) -> converter.apply(node));
    }

    public <K> Iterator<K> transform(final BiFunction<T, MerkleRoute, K> converter) {
        final MerkleIterator originalIterator = this;
        return new Iterator<K>(){

            @Override
            public boolean hasNext() {
                return originalIterator.hasNext();
            }

            @Override
            public K next() {
                Object node = originalIterator.next();
                MerkleRoute route = originalIterator.getRoute();
                return converter.apply(node, route);
            }
        };
    }

    public void forEachRemainingWithIO(IOConsumer<? super T> action) throws IOException {
        while (this.hasNext()) {
            action.accept(this.next());
        }
    }

    public void forEachRemainingWithInterrupt(InterruptableConsumer<? super T> action) throws InterruptedException {
        while (this.hasNext()) {
            action.accept(this.next());
        }
    }
}

