/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.route.internal;

import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.merkle.route.MerkleRoute;
import com.swirlds.common.merkle.route.internal.AbstractMerkleRoute;
import com.swirlds.common.merkle.route.internal.UncompressedMerkleRouteIterator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class UncompressedMerkleRoute
extends AbstractMerkleRoute {
    private static final long CLASS_ID = 2530250629558757735L;
    private static final int[] emptyData = new int[0];
    private int[] data;

    public UncompressedMerkleRoute() {
        this.data = emptyData;
    }

    private UncompressedMerkleRoute(UncompressedMerkleRoute baseRoute, int step) {
        this.data = Arrays.copyOf(baseRoute.data, baseRoute.data.length + 1);
        this.data[baseRoute.data.length] = step;
    }

    private UncompressedMerkleRoute(UncompressedMerkleRoute baseRoute, List<Integer> steps) {
        this.data = new int[baseRoute.data.length + steps.size()];
        System.arraycopy(baseRoute.data, 0, this.data, 0, baseRoute.data.length);
        int index = baseRoute.data.length;
        for (Integer step : steps) {
            if (step == null) {
                throw new NullPointerException("null steps are not allowed");
            }
            this.data[index] = step;
            ++index;
        }
    }

    private UncompressedMerkleRoute(UncompressedMerkleRoute baseRoute, int[] steps) {
        this.data = new int[baseRoute.data.length + steps.length];
        System.arraycopy(baseRoute.data, 0, this.data, 0, baseRoute.data.length);
        int index = baseRoute.data.length;
        int[] nArray = steps;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int step;
            this.data[index] = step = nArray[i];
            ++index;
        }
    }

    private UncompressedMerkleRoute(UncompressedMerkleRoute child) {
        if (child.data.length == 0) {
            throw new NoSuchElementException("Cannot get parent of root");
        }
        this.data = Arrays.copyOf(child.data, child.data.length - 1);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new UncompressedMerkleRouteIterator(this.data);
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public boolean isEmpty() {
        return this.data.length == 0;
    }

    @Override
    public MerkleRoute extendRoute(int step) {
        return new UncompressedMerkleRoute(this, step);
    }

    @Override
    public MerkleRoute extendRoute(List<Integer> steps) {
        if (steps == null || steps.isEmpty()) {
            return this;
        }
        return new UncompressedMerkleRoute(this, steps);
    }

    @Override
    public MerkleRoute extendRoute(int ... steps) {
        if (steps == null || steps.length == 0) {
            return this;
        }
        return new UncompressedMerkleRoute(this, steps);
    }

    @Override
    public MerkleRoute getParent() {
        return new UncompressedMerkleRoute(this);
    }

    @Override
    public int getStep(int index) {
        int normalizedIndex = index >= 0 ? index : this.data.length + index;
        return this.data[normalizedIndex];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UncompressedMerkleRoute that = (UncompressedMerkleRoute)o;
        return Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    @Override
    public long getClassId() {
        return 2530250629558757735L;
    }

    @Override
    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeIntArray(this.data);
    }

    @Override
    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.data = in.readIntArray(1024);
    }

    @Override
    public int getVersion() {
        return 1;
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

