/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.utility;

import com.swirlds.common.crypto.CryptographyHolder;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.formatting.TextEffect;
import com.swirlds.common.formatting.TextTable;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.iterators.MerkleIterationOrder;
import com.swirlds.common.merkle.iterators.MerkleIterator;
import com.swirlds.common.merkle.route.MerkleRoute;
import com.swirlds.common.merkle.route.MerkleRouteUtils;
import com.swirlds.common.merkle.utility.DebugIterationEndpoint;
import java.util.function.Predicate;

public class MerkleTreeVisualizer {
    private static final String INDENT = "   ";
    private final MerkleNode root;
    private boolean useColors = false;
    private boolean useMnemonics = false;
    private boolean useHashes = true;
    private boolean useFullRoute = true;
    private int hashLength = -1;
    private int depth = 10;
    private boolean ignoreDepthAnnotations = false;

    public MerkleTreeVisualizer(MerkleNode root) {
        this.root = root;
    }

    public MerkleTreeVisualizer setUseColors(boolean useColors) {
        this.useColors = useColors;
        return this;
    }

    public MerkleTreeVisualizer setUseMnemonics(boolean useMnemonics) {
        this.useMnemonics = useMnemonics;
        return this;
    }

    public MerkleTreeVisualizer setUseHashes(boolean useHashes) {
        this.useHashes = useHashes;
        return this;
    }

    public MerkleTreeVisualizer setUseFullRoute(boolean useFullRoute) {
        this.useFullRoute = useFullRoute;
        return this;
    }

    public MerkleTreeVisualizer setHashLength(int hashLength) {
        this.hashLength = hashLength;
        return this;
    }

    public MerkleTreeVisualizer setDepth(int depth) {
        this.depth = depth;
        return this;
    }

    public MerkleTreeVisualizer setIgnoreDepthAnnotations(boolean ignoreDepthAnnotations) {
        this.ignoreDepthAnnotations = ignoreDepthAnnotations;
        return this;
    }

    public String render() {
        StringBuilder sb = new StringBuilder();
        this.render(sb);
        return sb.toString();
    }

    public void render(StringBuilder sb) {
        int rootDepth = this.root == null ? 0 : this.root.getDepth();
        int maxDepth = rootDepth + this.depth;
        Predicate<MerkleInternal> filter = parent -> {
            boolean ignore = !this.ignoreDepthAnnotations && parent.getClass().isAnnotationPresent(DebugIterationEndpoint.class);
            boolean tooDeep = parent.getRoute().size() >= maxDepth;
            return !ignore && !tooDeep;
        };
        MerkleIterator iterator = new MerkleIterator(this.root).ignoreNull(false).setOrder(MerkleIterationOrder.PRE_ORDERED_DEPTH_FIRST).setDescendantFilter(filter);
        TextTable table = new TextTable().setExtraPadding(3).setBordersEnabled(false);
        iterator.forEachRemaining(node -> {
            String className;
            MerkleRoute route = iterator.getRoute();
            String indentation = INDENT.repeat(route.size() - rootDepth);
            String indexString = route.isEmpty() ? "(root)" : Integer.toString(route.getStep(-1));
            Hash hash = node == null ? CryptographyHolder.get().getNullHash() : node.getHash();
            String string = className = node == null ? "null" : node.getClass().getSimpleName();
            String hashString = hash == null ? "null" : (this.hashLength == -1 ? hash.toString() : hash.toString().substring(0, this.hashLength));
            String formattedIndexString = this.useColors ? TextEffect.BRIGHT_CYAN.apply(indexString) : indexString;
            String formattedClassName = this.useColors ? TextEffect.BRIGHT_YELLOW.apply(className) : className;
            String firstColumn = indentation + formattedIndexString + " " + formattedClassName;
            table.addRow(firstColumn);
            if (this.useFullRoute) {
                String routeString = MerkleRouteUtils.merkleRouteToPathFormat(route);
                String formattedRouteString = this.useColors ? TextEffect.BRIGHT_RED.apply(routeString) : routeString;
                table.addToRow(formattedRouteString);
            }
            if (this.useMnemonics) {
                String mnemonic = hash == null ? "" : hash.toMnemonic();
                String formattedMnemonic = this.useColors ? TextEffect.WHITE.apply(mnemonic) : mnemonic;
                table.addToRow(formattedMnemonic);
            }
            if (this.useHashes) {
                String formattedHashString = this.useColors ? TextEffect.GRAY.apply(hashString) : hashString;
                table.addToRow(formattedHashString);
            }
        });
        table.render(sb);
    }

    public String toString() {
        return this.render();
    }
}

