/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics;

import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.MetricConfig;
import com.swirlds.common.metrics.MetricType;
import com.swirlds.common.metrics.MetricsFactory;
import com.swirlds.common.utility.CommonUtils;
import java.util.EnumSet;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public interface DoubleGauge
extends Metric {
    @Override
    default public MetricType getMetricType() {
        return MetricType.GAUGE;
    }

    @Override
    default public Metric.DataType getDataType() {
        return Metric.DataType.FLOAT;
    }

    @Override
    default public EnumSet<Metric.ValueType> getValueTypes() {
        return EnumSet.of(Metric.ValueType.VALUE);
    }

    @Override
    default public Double get(Metric.ValueType valueType) {
        CommonUtils.throwArgNull(valueType, "valueType");
        if (valueType == Metric.ValueType.VALUE) {
            return this.get();
        }
        throw new IllegalArgumentException("Unsupported ValueType: " + valueType);
    }

    public double get();

    public void set(double var1);

    public static final class Config
    extends MetricConfig<DoubleGauge, Config> {
        private final double initialValue;

        public Config(String category, String name) {
            super(category, name, "%,11.3f");
            this.initialValue = 0.0;
        }

        private Config(String category, String name, String description, String unit, String format, double initialValue) {
            super(category, name, description, unit, format);
            this.initialValue = initialValue;
        }

        @Override
        public Config withDescription(String description) {
            return new Config(this.getCategory(), this.getName(), description, this.getUnit(), this.getFormat(), this.getInitialValue());
        }

        @Override
        public Config withUnit(String unit) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), unit, this.getFormat(), this.getInitialValue());
        }

        public Config withFormat(String format) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), format, this.getInitialValue());
        }

        public double getInitialValue() {
            return this.initialValue;
        }

        public Config withInitialValue(double initialValue) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), initialValue);
        }

        @Override
        public Class<DoubleGauge> getResultClass() {
            return DoubleGauge.class;
        }

        @Override
        DoubleGauge create(MetricsFactory factory) {
            return factory.createDoubleGauge(this);
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("initialValue", this.initialValue).toString();
        }
    }
}

