/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics;

import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.MetricConfig;
import com.swirlds.common.metrics.MetricType;
import com.swirlds.common.metrics.MetricsFactory;
import com.swirlds.common.utility.CommonUtils;
import java.util.EnumSet;
import java.util.function.IntBinaryOperator;
import java.util.function.IntSupplier;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public interface IntegerAccumulator
extends Metric {
    @Override
    default public MetricType getMetricType() {
        return MetricType.ACCUMULATOR;
    }

    @Override
    default public Metric.DataType getDataType() {
        return Metric.DataType.INT;
    }

    @Override
    default public EnumSet<Metric.ValueType> getValueTypes() {
        return EnumSet.of(Metric.ValueType.VALUE);
    }

    @Override
    default public Integer get(Metric.ValueType valueType) {
        CommonUtils.throwArgNull(valueType, "valueType");
        if (valueType == Metric.ValueType.VALUE) {
            return this.get();
        }
        throw new IllegalArgumentException("Unsupported ValueType: " + valueType);
    }

    public int get();

    public int getInitialValue();

    public void update(int var1);

    public static final class Config
    extends MetricConfig<IntegerAccumulator, Config> {
        private final IntBinaryOperator accumulator;
        private final IntSupplier initializer;
        private final int initialValue;

        public Config(String category, String name) {
            super(category, name, "%d");
            this.accumulator = Integer::max;
            this.initializer = null;
            this.initialValue = 0;
        }

        private Config(String category, String name, String description, String unit, String format, IntBinaryOperator accumulator, IntSupplier initializer, int initialValue) {
            super(category, name, description, unit, format);
            this.accumulator = CommonUtils.throwArgNull(accumulator, "accumulator");
            this.initializer = initializer;
            this.initialValue = initialValue;
        }

        @Override
        public Config withDescription(String description) {
            return new Config(this.getCategory(), this.getName(), description, this.getUnit(), this.getFormat(), this.getAccumulator(), this.getInitializer(), this.getInitialValue());
        }

        @Override
        public Config withUnit(String unit) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), unit, this.getFormat(), this.getAccumulator(), this.getInitializer(), this.getInitialValue());
        }

        public Config withFormat(String format) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), format, this.getAccumulator(), this.getInitializer(), this.getInitialValue());
        }

        public IntBinaryOperator getAccumulator() {
            return this.accumulator;
        }

        public Config withAccumulator(IntBinaryOperator accumulator) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), accumulator, this.getInitializer(), this.getInitialValue());
        }

        public IntSupplier getInitializer() {
            return this.initializer;
        }

        public Config withInitializer(IntSupplier initializer) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getAccumulator(), CommonUtils.throwArgNull(initializer, "initializer"), this.getInitialValue());
        }

        public int getInitialValue() {
            return this.initialValue;
        }

        public Config withInitialValue(int initialValue) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getAccumulator(), this.getInitializer(), initialValue);
        }

        @Override
        public Class<IntegerAccumulator> getResultClass() {
            return IntegerAccumulator.class;
        }

        @Override
        IntegerAccumulator create(MetricsFactory factory) {
            return factory.createIntegerAccumulator(this);
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("initialValue", this.initializer != null ? this.initializer.getAsInt() : this.initialValue).toString();
        }
    }
}

