/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics;

import com.swirlds.common.internal.SettingsCommon;
import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.MetricConfig;
import com.swirlds.common.metrics.MetricType;
import com.swirlds.common.metrics.MetricsFactory;
import java.util.EnumSet;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public interface RunningAverageMetric
extends Metric {
    @Override
    default public MetricType getMetricType() {
        return MetricType.RUNNING_AVERAGE;
    }

    @Override
    default public Metric.DataType getDataType() {
        return Metric.DataType.FLOAT;
    }

    @Override
    default public EnumSet<Metric.ValueType> getValueTypes() {
        return EnumSet.of(Metric.ValueType.VALUE, Metric.ValueType.MAX, Metric.ValueType.MIN, Metric.ValueType.STD_DEV);
    }

    @Override
    public Double get(Metric.ValueType var1);

    public double getHalfLife();

    public void update(double var1);

    public double get();

    public static final class Config
    extends MetricConfig<RunningAverageMetric, Config> {
        private final double halfLife;

        public Config(String category, String name) {
            super(category, name, "%,11.3f");
            this.halfLife = SettingsCommon.halfLife;
        }

        private Config(String category, String name, String description, String unit, String format, double halfLife) {
            super(category, name, description, unit, format);
            this.halfLife = halfLife;
        }

        @Override
        public Config withDescription(String description) {
            return new Config(this.getCategory(), this.getName(), description, this.getUnit(), this.getFormat(), this.getHalfLife());
        }

        @Override
        public Config withUnit(String unit) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), unit, this.getFormat(), this.getHalfLife());
        }

        public Config withFormat(String format) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), format, this.getHalfLife());
        }

        public double getHalfLife() {
            return this.halfLife;
        }

        public Config withHalfLife(double halfLife) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), halfLife);
        }

        @Override
        public Class<RunningAverageMetric> getResultClass() {
            return RunningAverageMetric.class;
        }

        @Override
        RunningAverageMetric create(MetricsFactory factory) {
            return factory.createRunningAverageMetric(this);
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("halfLife", this.halfLife).toString();
        }
    }
}

