/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.extensions;

import com.swirlds.common.metrics.FunctionGauge;
import com.swirlds.common.metrics.Metrics;
import com.swirlds.common.time.IntegerEpochTime;
import com.swirlds.common.time.OSTime;
import com.swirlds.common.time.Time;
import com.swirlds.common.utility.ByteUtils;
import com.swirlds.common.utility.StackTrace;
import com.swirlds.common.utility.throttle.RateLimiter;
import com.swirlds.logging.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BusyTime {
    private static final Logger log = LogManager.getLogger(BusyTime.class);
    private static final long WORK_START = 0L;
    private static final long WORK_END = 1L;
    private static final int INITIAL_STATUS = -1;
    private static final Duration LOG_PERIOD = Duration.ofSeconds(5L);
    private final IntegerEpochTime time;
    private final AtomicLong accumulator;
    private final RateLimiter logLimiter;

    public BusyTime() {
        this(OSTime.getInstance());
    }

    public BusyTime(@NonNull Time time) {
        this.time = new IntegerEpochTime(time);
        this.accumulator = new AtomicLong(ByteUtils.combineInts(this.time.getMicroTime(), -1));
        this.logLimiter = new RateLimiter(time, LOG_PERIOD);
    }

    public void addMetric(@NonNull Metrics metrics, @NonNull String category, @NonNull String name, @NonNull String description) {
        metrics.getOrCreate(((FunctionGauge.Config)((FunctionGauge.Config)new FunctionGauge.Config<Double>(category, name, Double.class, this::getAndReset).withDescription(description)).withUnit("fraction")).withFormat("%,1.3f"));
    }

    public void startingWork() {
        this.accumulator.accumulateAndGet(0L, this::statusUpdate);
    }

    public void finishedWork() {
        this.accumulator.accumulateAndGet(1L, this::statusUpdate);
    }

    public double getBusyFraction() {
        long pair = this.accumulator.get();
        return this.busyFraction(ByteUtils.extractLeftInt(pair), ByteUtils.extractRightInt(pair));
    }

    public double getAndReset() {
        long pair = this.accumulator.getAndUpdate(this::reset);
        return this.busyFraction(ByteUtils.extractLeftInt(pair), ByteUtils.extractRightInt(pair));
    }

    private double busyFraction(int measurementStart, int status) {
        int elapsedTime = this.time.microsElapsed(measurementStart);
        if (elapsedTime == 0) {
            return 0.0;
        }
        int busyTime = this.isIdle(status) ? Math.abs(status) - 1 : elapsedTime - (status - 1);
        return (double)busyTime / (double)elapsedTime;
    }

    private boolean isIdle(int status) {
        return status < 0;
    }

    private long statusUpdate(long previousPair, long statusChange) {
        int measurementStart = ByteUtils.extractLeftInt(previousPair);
        int currentStatus = ByteUtils.extractRightInt(previousPair);
        int currentTime = this.time.getMicroTime();
        if (statusChange == 0L && !this.isIdle(currentStatus) || statusChange == 1L && this.isIdle(currentStatus)) {
            if (this.logLimiter.request()) {
                log.error(LogMarker.EXCEPTION.getMarker(), "BusyTime metric has been updated incorrectly. Current status: {}, status change: {}, stack trace: \n{}", (Object)currentStatus, (Object)statusChange, (Object)StackTrace.getStackTrace().toString());
            }
            return previousPair;
        }
        int elapsedTime = IntegerEpochTime.elapsed(measurementStart, currentTime);
        if (statusChange == 0L) {
            int busyTime = Math.abs(currentStatus) - 1;
            int idleTime = elapsedTime - busyTime;
            return ByteUtils.combineInts(measurementStart, idleTime + 1);
        }
        int idleTime = currentStatus - 1;
        int busyTime = elapsedTime - idleTime;
        return ByteUtils.combineInts(measurementStart, -busyTime - 1);
    }

    private long reset(long currentPair) {
        return ByteUtils.combineInts(this.time.getMicroTime(), this.resetStatus(ByteUtils.extractRightInt(currentPair)));
    }

    private int resetStatus(int status) {
        if (status > 0) {
            return 1;
        }
        return -1;
    }
}

