/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.swirlds.common.metrics.FunctionGauge;
import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.MetricConfig;
import com.swirlds.common.metrics.platform.DefaultMetric;
import com.swirlds.common.metrics.platform.Snapshot;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class DefaultFunctionGauge<T>
extends DefaultMetric
implements FunctionGauge<T> {
    private final Metric.DataType dataType;
    private final Supplier<T> supplier;

    public DefaultFunctionGauge(FunctionGauge.Config<T> config) {
        super(config);
        this.dataType = MetricConfig.mapDataType(config.getType());
        this.supplier = config.getSupplier();
    }

    @Override
    public Metric.DataType getDataType() {
        return this.dataType;
    }

    @Override
    public List<Snapshot.SnapshotEntry> takeSnapshot() {
        return List.of(new Snapshot.SnapshotEntry(Metric.ValueType.VALUE, this.get()));
    }

    @Override
    public T get() {
        return this.supplier.get();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("value", this.supplier.get()).toString();
    }
}

