/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.swirlds.common.metrics.SpeedometerMetric;
import com.swirlds.common.metrics.platform.AbstractDistributionMetric;
import com.swirlds.common.statistics.StatsBuffered;
import com.swirlds.common.statistics.StatsSpeedometer;
import com.swirlds.common.time.OSTime;
import com.swirlds.common.time.Time;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class DefaultSpeedometerMetric
extends AbstractDistributionMetric
implements SpeedometerMetric {
    private final StatsSpeedometer speedometer;

    public DefaultSpeedometerMetric(SpeedometerMetric.Config config) {
        this(config, OSTime.getInstance());
    }

    public DefaultSpeedometerMetric(SpeedometerMetric.Config config, Time time) {
        super(config, config.getHalfLife());
        this.speedometer = new StatsSpeedometer(this.halfLife, time);
    }

    @Override
    public StatsBuffered getStatsBuffered() {
        return this.speedometer;
    }

    @Override
    public void update(double value) {
        this.speedometer.update(value);
    }

    @Override
    public void cycle() {
        this.update(1.0);
    }

    @Override
    public double get() {
        return this.speedometer.getCyclesPerSecond();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("halfLife", this.halfLife).append("value", this.get()).toString();
    }
}

