/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.swirlds.common.utility.CommonUtils;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class MetricsEventBus<T> {
    private final Executor executor;
    private final Queue<Consumer<? super T>> subscribers = new ConcurrentLinkedQueue<Consumer<? super T>>();

    public MetricsEventBus(Executor executor) {
        this.executor = CommonUtils.throwArgNull(executor, "executor");
    }

    public Runnable subscribe(Consumer<? super T> subscriber, Supplier<Stream<T>> previousEvents) {
        CommonUtils.throwArgNull(subscriber, "subscriber");
        CommonUtils.throwArgNull(previousEvents, "previousEvents");
        this.subscribers.add(subscriber);
        this.executor.execute(() -> ((Stream)previousEvents.get()).forEach(subscriber));
        return () -> this.subscribers.remove(subscriber);
    }

    public void submit(T event) {
        CommonUtils.throwArgNull(event, "event");
        this.executor.execute(() -> this.subscribers.forEach(subscriber -> subscriber.accept(event)));
    }
}

