/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.swirlds.base.state.Startable;
import com.swirlds.common.utility.CommonUtils;
import com.swirlds.common.utility.ThresholdLimitingHandler;
import com.swirlds.logging.LogMarker;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class MetricsUpdateService
implements Startable {
    private static final Logger logger = LogManager.getLogger(MetricsUpdateService.class);
    private static final long NO_DELAY = 0L;
    private final ScheduledExecutorService executor;
    private final long period;
    private final TimeUnit unit;
    private final Queue<Runnable> updaters = new ConcurrentLinkedQueue<Runnable>();
    private final ThresholdLimitingHandler<Throwable> exceptionRateLimiter = new ThresholdLimitingHandler(10L);
    private final AtomicReference<State> state;
    private ScheduledFuture<?> future;

    MetricsUpdateService(ScheduledExecutorService executor, long period, TimeUnit unit) {
        this.executor = CommonUtils.throwArgNull(executor, "executor");
        this.period = period;
        this.unit = unit;
        this.state = new AtomicReference<State>(State.INIT);
    }

    public void addUpdater(Runnable updater) {
        CommonUtils.throwArgNull(updater, "updater");
        this.updaters.add(updater);
    }

    public void removeUpdater(Runnable updater) {
        CommonUtils.throwArgNull(updater, "updater");
        this.updaters.remove(updater);
    }

    public void start() {
        if (this.state.compareAndSet(State.INIT, State.RUNNING)) {
            this.future = this.executor.scheduleAtFixedRate(this::runUpdaters, 0L, this.period, this.unit);
        }
    }

    public boolean shutdown() throws InterruptedException {
        if (this.future != null && this.state.compareAndSet(State.RUNNING, State.SHUTDOWN)) {
            this.future.cancel(true);
            try {
                this.future.get(1L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                return false;
            }
            catch (ExecutionException e) {
                logger.error("MetricsUpdateService.runUpdaters threw an unexpected exception", (Throwable)e);
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
        }
        return true;
    }

    private void runUpdaters() {
        for (Runnable updater : this.updaters) {
            try {
                updater.run();
            }
            catch (RuntimeException e) {
                this.exceptionRateLimiter.handle(e, error -> logger.error(LogMarker.EXCEPTION.getMarker(), "Exception while updating metrics.", error));
            }
        }
    }

    private static enum State {
        INIT,
        RUNNING,
        SHUTDOWN;

    }
}

