/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.stream;

import com.swirlds.common.crypto.DigestType;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.crypto.HashingOutputStream;
import com.swirlds.common.crypto.Signature;
import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.stream.StreamType;
import com.swirlds.common.stream.internal.InvalidStreamFileException;
import com.swirlds.common.stream.internal.SingleStreamIterator;
import com.swirlds.common.stream.internal.StreamFilesIterator;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang3.tuple.Pair;

public final class LinkedObjectStreamUtilities {
    private static final int NANO_DIGITS_COUNT = 9;

    private LinkedObjectStreamUtilities() {
    }

    public static String generateStreamFileNameFromInstant(Instant timestamp, StreamType streamType) {
        return LinkedObjectStreamUtilities.convertInstantToStringWithPadding(timestamp) + "." + streamType.getExtension();
    }

    public static String convertInstantToStringWithPadding(Instant timestamp) {
        String string = timestamp.toString().replace(":", "_");
        StringBuilder stringBuilder = new StringBuilder(string);
        int nanoStartIdx = string.indexOf(".");
        int nanoEndIdx = string.indexOf("Z");
        int numOfNanoDigits = nanoStartIdx == -1 ? 0 : nanoEndIdx - nanoStartIdx - 1;
        int numOfZeroPadding = 9 - numOfNanoDigits;
        if (numOfZeroPadding == 0) {
            return string;
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        if (nanoStartIdx == -1) {
            stringBuilder.append('.');
        }
        for (int i = 0; i < numOfZeroPadding; ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append('Z');
        return stringBuilder.toString();
    }

    public static String generateSigFilePath(File file) {
        return file.getAbsolutePath() + "_sig";
    }

    public static long getPeriod(Instant consensusTimestamp, long logPeriodMs) {
        long nanos = consensusTimestamp.getEpochSecond() * 1000000000L + (long)consensusTimestamp.getNano();
        return nanos / 1000000L / logPeriodMs;
    }

    public static Instant getTimeStampFromFileName(String filename) {
        int indexOfZ = filename.indexOf("Z");
        if (indexOfZ != -1) {
            String dateInfo = filename.substring(0, indexOfZ + 1);
            dateInfo = dateInfo.replace("_", ":");
            return Instant.parse(dateInfo);
        }
        return null;
    }

    public static String getFileExtension(File file) {
        int lastIndexOf = file.getName().lastIndexOf(".");
        if (lastIndexOf == -1) {
            return "";
        }
        return file.getName().substring(lastIndexOf + 1);
    }

    public static <T extends SelfSerializable> SingleStreamIterator<T> parseStreamFile(File file, StreamType streamType) {
        if (!streamType.isStreamFile(file)) {
            String msg = String.format("Fail to parse File %s, its extension doesn't match %s", file.getName(), streamType.getExtension());
            throw new IllegalArgumentException(msg);
        }
        return new SingleStreamIterator(file, streamType);
    }

    public static <T extends SelfSerializable> Iterator<T> parseStreamDirOrFile(File objectStreamDirOrFile, StreamType streamType) throws InvalidStreamFileException {
        if (objectStreamDirOrFile.isDirectory()) {
            return new StreamFilesIterator(objectStreamDirOrFile.listFiles(streamType::isStreamFile), streamType);
        }
        if (!streamType.isStreamFile(objectStreamDirOrFile)) {
            throw new InvalidStreamFileException(String.format("the file %s doesn't match streamType %s", objectStreamDirOrFile.getName(), streamType));
        }
        return LinkedObjectStreamUtilities.parseStreamFile(objectStreamDirOrFile, streamType);
    }

    public static <T extends SelfSerializable> Iterator<T> parseStreamFileList(Collection<File> files, StreamType streamType) {
        return new StreamFilesIterator((File[])files.toArray(File[]::new), streamType);
    }

    public static Hash readStartRunningHashFromStreamFile(File file, StreamType streamType) {
        SingleStreamIterator singleStreamIterator = LinkedObjectStreamUtilities.parseStreamFile(file, streamType);
        Hash startRunningHash = (Hash)singleStreamIterator.next();
        singleStreamIterator.closeStream();
        return startRunningHash;
    }

    public static <T extends SelfSerializable> Pair<Hash, Hash> readHashesFromStreamFile(File file, StreamType streamType) throws InvalidStreamFileException {
        Hash endRunningHash;
        Hash startRunningHash;
        SingleStreamIterator<T> iterator = LinkedObjectStreamUtilities.parseStreamFile(file, streamType);
        try {
            startRunningHash = (Hash)iterator.next();
        }
        catch (ClassCastException e) {
            throw new InvalidStreamFileException(String.format("File %s doesn't contain startRunningHash", file.getName()), e);
        }
        Object object = null;
        while (iterator.hasNext()) {
            object = iterator.next();
        }
        try {
            endRunningHash = (Hash)object;
        }
        catch (ClassCastException e) {
            throw new InvalidStreamFileException(String.format("File %s doesn't contain endRunningHash", file.getName()), e);
        }
        iterator.closeStream();
        return Pair.of((Object)startRunningHash, (Object)endRunningHash);
    }

    public static Pair<Pair<Hash, Signature>, Pair<Hash, Signature>> parseSigFile(File file, StreamType streamType) throws IOException, InvalidStreamFileException {
        if (!streamType.isStreamSigFile(file.getName())) {
            throw new InvalidStreamFileException(String.format("parseSigFile : fail to read signature from File %s, its extension doesn't match %s", file.getName(), streamType.getSigExtension()));
        }
        try (SerializableDataInputStream inputStream = new SerializableDataInputStream(new BufferedInputStream(new FileInputStream(file)));){
            for (int i = 0; i < streamType.getSigFileHeader().length; ++i) {
                inputStream.readByte();
            }
            inputStream.readInt();
            Hash entireHash = (Hash)inputStream.readSerializable();
            Signature entireSignature = (Signature)inputStream.readSerializable();
            Hash metaHash = (Hash)inputStream.readSerializable();
            Signature metaSignature = (Signature)inputStream.readSerializable();
            Pair pair = Pair.of((Object)Pair.of((Object)entireHash, (Object)entireSignature), (Object)Pair.of((Object)metaHash, (Object)metaSignature));
            return pair;
        }
    }

    /*
     * Exception decompiling
     */
    public static Hash computeEntireHash(File file) throws IOException, NoSuchAlgorithmException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Hash computeMetaHash(File file, StreamType streamType) throws IOException, NoSuchAlgorithmException, InvalidStreamFileException {
        MessageDigest md = MessageDigest.getInstance(DigestType.SHA_384.algorithmName());
        try (SerializableDataOutputStream outputStream = new SerializableDataOutputStream(new HashingOutputStream(md));){
            for (int num : streamType.getFileHeader()) {
                outputStream.writeInt(num);
            }
            outputStream.writeInt(1);
            Pair<Hash, Hash> hashPair = LinkedObjectStreamUtilities.readHashesFromStreamFile(file, streamType);
            outputStream.writeSerializable((SelfSerializable)hashPair.getLeft(), true);
            outputStream.writeSerializable((SelfSerializable)hashPair.getRight(), true);
        }
        return new Hash(md.digest());
    }

    public static int readFirstIntFromFile(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            int n;
            try (SerializableDataInputStream inputStream = new SerializableDataInputStream(fis);){
                n = inputStream.readInt();
            }
            return n;
        }
    }
}

