/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.stream.internal;

import com.swirlds.common.crypto.Hash;
import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.stream.LinkedObjectStreamUtilities;
import com.swirlds.common.stream.StreamType;
import com.swirlds.logging.LogMarker;
import com.swirlds.logging.payloads.StreamParseErrorPayload;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.util.Supplier;

public class StreamFilesIterator<T extends SelfSerializable>
implements Iterator<T> {
    private static final Logger logger = LogManager.getLogger(StreamFilesIterator.class);
    private static final Marker LOGM_OBJECT_STREAM_FILE = LogMarker.OBJECT_STREAM_FILE.getMarker();
    private static final Marker LOGM_EXCEPTION = LogMarker.EXCEPTION.getMarker();
    private File[] files;
    private int idx;
    private Hash startRunningHash;
    private Hash endRunningHash;
    private Iterator<T> currentFileIterator;
    private T next;
    private StreamType streamType;

    public StreamFilesIterator(File[] files, StreamType streamType) {
        this.streamType = streamType;
        this.files = (File[])Arrays.stream(files).filter(streamType::isStreamFile).sorted(Comparator.comparing(File::getName)).toArray(File[]::new);
        Arrays.sort(files, Comparator.comparing(File::getName));
        logger.info(LOGM_OBJECT_STREAM_FILE, "StreamFilesIterator : files to be parsed: {}", new Supplier[]{() -> Arrays.toString(files)});
        this.idx = 0;
        this.endRunningHash = null;
        this.startRunningHash = null;
        this.currentFileIterator = this.idx < files.length ? LinkedObjectStreamUtilities.parseStreamFile(files[this.idx], streamType) : null;
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        return this.fetchNext();
    }

    @Override
    public T next() {
        T object = this.next;
        this.next = null;
        this.fetchNext();
        return object;
    }

    private boolean fetchNext() {
        if (this.currentFileIterator == null || !this.currentFileIterator.hasNext() && this.idx == this.files.length - 1) {
            return false;
        }
        if (this.fetchNextInCurrentFileIterator()) {
            return true;
        }
        return this.readNextFile();
    }

    private boolean fetchNextInCurrentFileIterator() {
        if (!this.currentFileIterator.hasNext()) {
            return false;
        }
        SelfSerializable object = (SelfSerializable)this.currentFileIterator.next();
        boolean nextExists = true;
        if (object instanceof Hash) {
            if (this.startRunningHash == null) {
                this.next = object;
                this.startRunningHash = (Hash)object;
                logger.info(LOGM_OBJECT_STREAM_FILE, "StreamFilesIterator : first startRunningHash: {}", new Supplier[]{() -> this.startRunningHash});
                return true;
            }
            this.endRunningHash = (Hash)object;
            logger.info(LOGM_OBJECT_STREAM_FILE, "StreamFilesIterator : update endRunningHash: {}", new Supplier[]{() -> this.endRunningHash});
            if (this.idx == this.files.length - 1) {
                this.next = object;
                logger.info(LOGM_OBJECT_STREAM_FILE, "StreamFilesIterator : last endRunningHash: {}", new Supplier[]{() -> object});
            } else {
                nextExists = false;
            }
        } else {
            this.next = object;
        }
        return nextExists;
    }

    boolean readNextFile() {
        ++this.idx;
        this.currentFileIterator = LinkedObjectStreamUtilities.parseStreamFile(this.files[this.idx], this.streamType);
        if (!this.currentFileIterator.hasNext()) {
            logger.error(LOGM_EXCEPTION, () -> new StreamParseErrorPayload(String.format("Fail to parse %s", this.files[this.idx].getName())));
            return false;
        }
        SelfSerializable hash = (SelfSerializable)this.currentFileIterator.next();
        if (!(hash instanceof Hash)) {
            logger.error(LOGM_EXCEPTION, () -> new StreamParseErrorPayload(String.format("The first item %s in %s is not Hash", hash, this.files[this.idx].getName())));
            return false;
        }
        this.startRunningHash = (Hash)hash;
        logger.info(LOGM_OBJECT_STREAM_FILE, "StreamFilesIterator : update startRunningHash: {}", new Supplier[]{() -> this.startRunningHash});
        if (!this.startRunningHash.equals(this.endRunningHash)) {
            logger.error(LOGM_EXCEPTION, () -> new StreamParseErrorPayload(String.format("startRunningHash %s in %s doesn't match endRunningHash %s in %s", this.startRunningHash, this.files[this.idx].getName(), this.endRunningHash, this.files[this.idx - 1].getName())));
            return false;
        }
        if (!this.currentFileIterator.hasNext()) {
            logger.error(LOGM_EXCEPTION, () -> new StreamParseErrorPayload(String.format("file %s only contains startRunningHash", this.files[this.idx].getName())));
            return false;
        }
        this.next = (SelfSerializable)this.currentFileIterator.next();
        return true;
    }
}

