/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system;

import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Objects;

public class NodeId
implements Comparable<NodeId>,
SelfSerializable {
    private static final long CLASS_ID = -1562170937950090579L;
    public static final long LOWEST_NODE_NUMBER = 0L;
    public static final NodeId FIRST_NODE_ID = new NodeId(0L);
    private long id;

    public NodeId() {
    }

    public NodeId(long id) {
        if (id < 0L) {
            throw new IllegalArgumentException("id must be non-negative");
        }
        this.id = id;
    }

    @Override
    public long getClassId() {
        return -1562170937950090579L;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public int getMinimumSupportedVersion() {
        return 1;
    }

    public long id() {
        return this.id;
    }

    @Override
    public int compareTo(@NonNull NodeId other) {
        Objects.requireNonNull(other, "NodeId cannot be null");
        return Long.compare(this.id, other.id);
    }

    @Deprecated(since="0.39.0", forRemoval=true)
    public int getIdAsInt() {
        return (int)this.id;
    }

    @NonNull
    public String toString() {
        return Long.toString(this.id);
    }

    @Override
    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeLong(this.id);
    }

    @Override
    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.id = in.readLong();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || NodeId.class != o.getClass()) {
            return false;
        }
        NodeId nodeId = (NodeId)o;
        return this.id == nodeId.id;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

