/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system.address;

import com.swirlds.common.crypto.SerializablePublicKey;
import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.system.NodeId;
import com.swirlds.common.utility.NonCryptographicHashing;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class Address
implements SelfSerializable {
    private static final long CLASS_ID = 408980092978607982L;
    private static final byte[] ALL_INTERFACES = new byte[]{0, 0, 0, 0};
    private static final int MAX_IP_LENGTH = 16;
    private static final int STRING_MAX_BYTES = 512;
    private NodeId id;
    private String nickname;
    private String selfName;
    private boolean ownHost;
    private long weight;
    private byte[] addressInternalIpv4;
    private int portInternalIpv4;
    private byte[] addressExternalIpv4;
    private int portExternalIpv4;
    private byte[] addressInternalIpv6;
    private int portInternalIpv6;
    private int portExternalIpv6;
    private byte[] addressExternalIpv6;
    private SerializablePublicKey sigPublicKey;
    private SerializablePublicKey encPublicKey;
    private SerializablePublicKey agreePublicKey;
    private String memo;

    public Address() {
        this(NodeId.FIRST_NODE_ID, "", "", 1L, false, null, -1, null, -1, null, -1, null, -1, (SerializablePublicKey)null, (SerializablePublicKey)null, (SerializablePublicKey)null, "");
    }

    public Address(@NonNull NodeId id, @NonNull String nickname, @NonNull String selfName, long weight, boolean ownHost, @Nullable byte[] addressInternalIpv4, int portInternalIpv4, @Nullable byte[] addressExternalIpv4, int portExternalIpv4, @NonNull String memo) {
        this(id, nickname, selfName, weight, ownHost, addressInternalIpv4, portInternalIpv4, addressExternalIpv4, portExternalIpv4, null, -1, null, -1, null, null, (SerializablePublicKey)null, memo);
    }

    private byte[] clone(byte[] x) {
        return x == null ? x : (byte[])x.clone();
    }

    @Deprecated
    public Address(long id, @NonNull String nickname, @NonNull String selfName, long weight, boolean ownHost, @Nullable byte[] addressInternalIpv4, int portInternalIpv4, @Nullable byte[] addressExternalIpv4, int portExternalIpv4, @Nullable byte[] addressInternalIpv6, int portInternalIpv6, @Nullable byte[] addressExternalIpv6, int portExternalIpv6, @Nullable PublicKey sigPublicKey, @Nullable PublicKey encPublicKey, @Nullable PublicKey agreePublicKey, @NonNull String memo) {
        this(new NodeId(id), nickname, selfName, weight, ownHost, addressInternalIpv4, portInternalIpv4, addressExternalIpv4, portExternalIpv4, addressInternalIpv6, portInternalIpv6, addressExternalIpv6, portExternalIpv6, sigPublicKey == null ? null : new SerializablePublicKey(sigPublicKey), encPublicKey == null ? null : new SerializablePublicKey(encPublicKey), agreePublicKey == null ? null : new SerializablePublicKey(agreePublicKey), memo);
    }

    public Address(@NonNull NodeId id, @NonNull String nickname, @NonNull String selfName, long weight, boolean ownHost, @Nullable byte[] addressInternalIpv4, int portInternalIpv4, @Nullable byte[] addressExternalIpv4, int portExternalIpv4, @Nullable byte[] addressInternalIpv6, int portInternalIpv6, @Nullable byte[] addressExternalIpv6, int portExternalIpv6, @Nullable SerializablePublicKey sigPublicKey, @Nullable SerializablePublicKey encPublicKey, @Nullable SerializablePublicKey agreePublicKey, @NonNull String memo) {
        this.id = Objects.requireNonNull(id, "id must not be null");
        this.nickname = Objects.requireNonNull(nickname, "nickname must not be null");
        this.selfName = Objects.requireNonNull(selfName, "selfName must not be null");
        this.weight = weight;
        this.ownHost = ownHost;
        this.portInternalIpv4 = portInternalIpv4;
        this.portInternalIpv6 = portInternalIpv6;
        this.portExternalIpv4 = portExternalIpv4;
        this.portExternalIpv6 = portExternalIpv6;
        this.addressInternalIpv4 = this.clone(addressInternalIpv4);
        this.addressInternalIpv6 = this.clone(addressInternalIpv6);
        this.addressExternalIpv4 = this.clone(addressExternalIpv4);
        this.addressExternalIpv6 = this.clone(addressExternalIpv6);
        this.sigPublicKey = sigPublicKey;
        this.encPublicKey = encPublicKey;
        this.agreePublicKey = agreePublicKey;
        this.memo = Objects.requireNonNull(memo, "memo must not be null");
    }

    @Override
    public int getMinimumSupportedVersion() {
        return 3;
    }

    @Override
    public int getVersion() {
        return 4;
    }

    @Override
    public long getClassId() {
        return 408980092978607982L;
    }

    public long getWeight() {
        return this.weight;
    }

    public boolean isZeroWeight() {
        return this.weight == 0L;
    }

    @NonNull
    public NodeId getNodeId() {
        return this.id;
    }

    @Deprecated(since="0.39.0", forRemoval=true)
    public long getId() {
        return this.id.id();
    }

    @NonNull
    public String getNickname() {
        return this.nickname;
    }

    @NonNull
    public String getSelfName() {
        return this.selfName;
    }

    public boolean isOwnHost() {
        return this.ownHost;
    }

    public int getConnectPortIpv4(Address a) {
        return this.isLocalTo(a) ? this.getPortInternalIpv4() : this.getPortExternalIpv4();
    }

    public boolean isLocalTo(Address a) {
        return Arrays.equals(this.getAddressExternalIpv4(), a.getAddressExternalIpv4());
    }

    @NonNull
    public byte[] getListenAddressIpv4() {
        return ALL_INTERFACES;
    }

    public int getListenPortIpv4() {
        return this.getPortInternalIpv4();
    }

    public int getPortInternalIpv4() {
        return this.portInternalIpv4;
    }

    public int getPortInternalIpv6() {
        return this.portInternalIpv6;
    }

    public int getPortExternalIpv4() {
        return this.portExternalIpv4;
    }

    public int getPortExternalIpv6() {
        return this.portExternalIpv6;
    }

    @Nullable
    public byte[] getAddressInternalIpv4() {
        return this.clone(this.addressInternalIpv4);
    }

    @Nullable
    public byte[] getAddressInternalIpv6() {
        return this.clone(this.addressInternalIpv6);
    }

    @Nullable
    public byte[] getAddressExternalIpv4() {
        return this.clone(this.addressExternalIpv4);
    }

    @Nullable
    public byte[] getAddressExternalIpv6() {
        return this.clone(this.addressExternalIpv6);
    }

    @Nullable
    public PublicKey getSigPublicKey() {
        return this.sigPublicKey.getPublicKey();
    }

    @Nullable
    public PublicKey getEncPublicKey() {
        return this.encPublicKey.getPublicKey();
    }

    @Nullable
    public PublicKey getAgreePublicKey() {
        return this.agreePublicKey.getPublicKey();
    }

    @NonNull
    public String getMemo() {
        return this.memo;
    }

    @NonNull
    public Address copySetNodeId(@NonNull NodeId id) {
        Objects.requireNonNull(id, "id must not be null");
        Address a = this.copy();
        a.id = id;
        return a;
    }

    @NonNull
    public Address copySetWeight(long weight) {
        Address a = this.copy();
        a.weight = weight;
        return a;
    }

    @NonNull
    public Address copySetNickname(@NonNull String nickname) {
        Objects.requireNonNull(nickname, "nickname must not be null");
        Address a = this.copy();
        a.nickname = nickname;
        return a;
    }

    @NonNull
    public Address copySetSelfName(@NonNull String selfName) {
        Objects.requireNonNull(selfName, "selfName must not be null");
        Address a = this.copy();
        a.selfName = selfName;
        return a;
    }

    @NonNull
    public Address copySetOwnHost(boolean ownHost) {
        Address a = this.copy();
        a.ownHost = ownHost;
        return a;
    }

    @NonNull
    public Address copySetPortInternalIpv4(int portInternalIpv4) {
        Address a = this.copy();
        a.portInternalIpv4 = portInternalIpv4;
        return a;
    }

    @NonNull
    public Address copySetPortInternalIpv6(int portInternalIpv6) {
        Address a = this.copy();
        a.portInternalIpv6 = portInternalIpv6;
        return a;
    }

    @NonNull
    public Address copySetPortExternalIpv4(int portExternalIpv4) {
        Address a = this.copy();
        a.portExternalIpv4 = portExternalIpv4;
        return a;
    }

    @NonNull
    public Address copySetPortExternalIpv6(int portExternalIpv6) {
        Address a = this.copy();
        a.portExternalIpv6 = portExternalIpv6;
        return a;
    }

    @NonNull
    public Address copySetAddressInternalIpv4(@NonNull byte[] addressInternalIpv4) {
        Objects.requireNonNull(addressInternalIpv4, "addressInternalIpv4 must not be null");
        Address a = this.copy();
        a.addressInternalIpv4 = this.clone(addressInternalIpv4);
        return a;
    }

    @NonNull
    public Address copySetAddressInternalIpv6(@NonNull byte[] addressInternalIpv6) {
        Objects.requireNonNull(addressInternalIpv6, "addressInternalIpv6 must not be null");
        Address a = this.copy();
        a.addressInternalIpv6 = this.clone(addressInternalIpv6);
        return a;
    }

    @NonNull
    public Address copySetAddressExternalIpv4(@NonNull byte[] addressExternalIpv4) {
        Objects.requireNonNull(addressExternalIpv4, "addressExternalIpv4 must not be null");
        Address a = this.copy();
        a.addressExternalIpv4 = this.clone(addressExternalIpv4);
        return a;
    }

    @NonNull
    public Address copySetAddressExternalIpv6(@NonNull byte[] addressExternalIpv6) {
        Objects.requireNonNull(addressExternalIpv6, "addressExternalIpv6 must not be null");
        Address a = this.copy();
        a.addressExternalIpv6 = this.clone(addressExternalIpv6);
        return a;
    }

    @NonNull
    public Address copySetSigPublicKey(@NonNull PublicKey sigPublicKey) {
        Objects.requireNonNull(sigPublicKey, "sigPublicKey must not be null");
        Address a = this.copy();
        a.sigPublicKey = new SerializablePublicKey(sigPublicKey);
        return a;
    }

    @NonNull
    public Address copySetEncPublicKey(@NonNull PublicKey encPublicKey) {
        Objects.requireNonNull(encPublicKey, "encPublicKey must not be null");
        Address a = this.copy();
        a.encPublicKey = new SerializablePublicKey(encPublicKey);
        return a;
    }

    @NonNull
    public Address copySetAgreePublicKey(@NonNull PublicKey agreePublicKey) {
        Objects.requireNonNull(agreePublicKey, "agreePublicKey must not be null");
        Address a = this.copy();
        a.agreePublicKey = new SerializablePublicKey(agreePublicKey);
        return a;
    }

    @NonNull
    public Address copySetMemo(@NonNull String memo) {
        Objects.requireNonNull(memo, "memo must not be null");
        Address a = this.copy();
        a.memo = memo;
        return a;
    }

    public Address copy() {
        return new Address(this.id, this.nickname, this.selfName, this.weight, this.ownHost, this.addressInternalIpv4, this.portInternalIpv4, this.addressExternalIpv4, this.portExternalIpv4, this.addressInternalIpv6, this.portInternalIpv6, this.addressExternalIpv6, this.portExternalIpv6, this.sigPublicKey, this.encPublicKey, this.agreePublicKey, this.memo);
    }

    @Deprecated
    public void writeAddress(SerializableDataOutputStream outStream) throws IOException {
        this.serialize(outStream);
    }

    @Deprecated(forRemoval=true)
    public static Address readAddress(SerializableDataInputStream inStream, long version) throws IOException {
        Address address = new Address();
        address.deserialize(inStream, (int)version);
        return address;
    }

    @Override
    public void serialize(SerializableDataOutputStream outStream) throws IOException {
        outStream.writeSerializable(this.id, false);
        outStream.writeNormalisedString(this.nickname);
        outStream.writeNormalisedString(this.selfName);
        outStream.writeLong(this.weight);
        outStream.writeByteArray(this.addressInternalIpv4);
        outStream.writeInt(this.portInternalIpv4);
        outStream.writeByteArray(this.addressExternalIpv4);
        outStream.writeInt(this.portExternalIpv4);
        outStream.writeByteArray(this.addressInternalIpv6);
        outStream.writeInt(this.portInternalIpv6);
        outStream.writeByteArray(this.addressExternalIpv6);
        outStream.writeInt(this.portExternalIpv6);
        outStream.writeSerializable(this.sigPublicKey, false);
        outStream.writeSerializable(this.encPublicKey, false);
        outStream.writeSerializable(this.agreePublicKey, false);
        outStream.writeNormalisedString(this.memo);
    }

    @Override
    public void deserialize(SerializableDataInputStream inStream, int version) throws IOException {
        this.id = version < 4 ? new NodeId(inStream.readLong()) : inStream.readSerializable(false, NodeId::new);
        this.nickname = inStream.readNormalisedString(512);
        this.selfName = inStream.readNormalisedString(512);
        this.weight = inStream.readLong();
        this.ownHost = false;
        this.addressInternalIpv4 = inStream.readByteArray(16);
        this.portInternalIpv4 = inStream.readInt();
        this.addressExternalIpv4 = inStream.readByteArray(16);
        this.portExternalIpv4 = inStream.readInt();
        this.addressInternalIpv6 = inStream.readByteArray(16);
        this.portInternalIpv6 = inStream.readInt();
        this.addressExternalIpv6 = inStream.readByteArray(16);
        this.portExternalIpv6 = inStream.readInt();
        switch (version) {
            case 1: {
                this.sigPublicKey = new SerializablePublicKey();
                this.encPublicKey = new SerializablePublicKey();
                this.agreePublicKey = new SerializablePublicKey();
                this.sigPublicKey.deserializeVersion0(inStream, "RSA");
                this.encPublicKey.deserializeVersion0(inStream, "EC");
                this.agreePublicKey.deserializeVersion0(inStream, "EC");
                break;
            }
            case 2: {
                this.sigPublicKey = new SerializablePublicKey();
                this.encPublicKey = new SerializablePublicKey();
                this.agreePublicKey = new SerializablePublicKey();
                this.sigPublicKey.deserialize(inStream, 1);
                this.encPublicKey.deserialize(inStream, 1);
                this.agreePublicKey.deserialize(inStream, 1);
                break;
            }
            default: {
                this.sigPublicKey = inStream.readSerializable(false, SerializablePublicKey::new);
                this.encPublicKey = inStream.readSerializable(false, SerializablePublicKey::new);
                this.agreePublicKey = inStream.readSerializable(false, SerializablePublicKey::new);
            }
        }
        this.memo = inStream.readNormalisedString(512);
    }

    public static String ipString(byte[] ip) {
        return (0xFF & ip[0]) + "." + (0xFF & ip[1]) + "." + (0xFF & ip[2]) + "." + (0xFF & ip[3]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return this.equalsWithoutWeightAndOwnHost(address) && this.ownHost == address.ownHost && this.weight == address.weight;
    }

    public boolean equalsWithoutWeightAndOwnHost(@NonNull Address address) {
        return Objects.equals(this.id, address.id) && this.portInternalIpv4 == address.portInternalIpv4 && this.portExternalIpv4 == address.portExternalIpv4 && this.portInternalIpv6 == address.portInternalIpv6 && this.portExternalIpv6 == address.portExternalIpv6 && Objects.equals(this.nickname, address.nickname) && Objects.equals(this.selfName, address.selfName) && Arrays.equals(this.addressInternalIpv4, address.addressInternalIpv4) && Arrays.equals(this.addressExternalIpv4, address.addressExternalIpv4) && Arrays.equals(this.addressInternalIpv6, address.addressInternalIpv6) && Arrays.equals(this.addressExternalIpv6, address.addressExternalIpv6) && Arrays.equals(this.sigPublicKey.getPublicKey().getEncoded(), address.sigPublicKey.getPublicKey().getEncoded()) && Arrays.equals(this.encPublicKey.getPublicKey().getEncoded(), address.encPublicKey.getPublicKey().getEncoded()) && Arrays.equals(this.agreePublicKey.getPublicKey().getEncoded(), address.agreePublicKey.getPublicKey().getEncoded()) && Objects.equals(this.memo, address.memo);
    }

    public int hashCode() {
        return NonCryptographicHashing.hash32(this.id.id());
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)this.id).append("nickname", (Object)this.nickname).append("selfName", (Object)this.selfName).append("ownHost", this.ownHost).append("weight", this.weight).append("addressInternalIpv4", (Object)Arrays.toString(this.addressInternalIpv4)).append("portInternalIpv4", this.portInternalIpv4).append("addressExternalIpv4", (Object)Arrays.toString(this.addressExternalIpv4)).append("portExternalIpv4", this.portExternalIpv4).append("addressInternalIpv6", (Object)Arrays.toString(this.addressInternalIpv6)).append("portInternalIpv6", this.portInternalIpv6).append("portExternalIpv6", this.portExternalIpv6).append("addressExternalIpv6", (Object)Arrays.toString(this.addressExternalIpv6)).append("sigPublicKey", (Object)this.sigPublicKey).append("encPublicKey", (Object)this.encPublicKey).append("agreePublicKey", (Object)this.agreePublicKey).append("memo", (Object)this.memo).toString();
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 3;
        public static final int SELF_SERIALIZABLE_NODE_ID = 4;

        private ClassVersion() {
        }
    }
}

