/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system.address;

import com.swirlds.common.system.NodeId;
import com.swirlds.common.system.address.Address;
import com.swirlds.common.system.address.AddressBook;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.Objects;
import java.util.function.Function;

public class AddressBookUtils {
    private AddressBookUtils() {
    }

    @NonNull
    public static Address parseAddressConfigText(@NonNull String addressLine, @NonNull NodeId id, @NonNull Function<InetAddress, Boolean> isOwnHostDeterminer, @NonNull String memo) throws ParseException {
        int externalPort;
        InetAddress externalIp;
        int internalPort;
        InetAddress internalIp;
        Long weight;
        Objects.requireNonNull(addressLine, "The addressLine must not be null.");
        Objects.requireNonNull(id, "The id must not be null.");
        Objects.requireNonNull(isOwnHostDeterminer, "The isOwnHostDeterminer must not be null.");
        Objects.requireNonNull(memo, "The memo must not be null.");
        String[] parts = addressLine.trim().split(",");
        if (parts.length < 8 || parts.length > 9) {
            throw new ParseException("Incorrect number of parts in the address line to parse correctly.", parts.length);
        }
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = parts[i].trim();
        }
        if (!parts[0].equals("address")) {
            throw new ParseException("The address line must start with 'address' and not '" + parts[0] + "'", 0);
        }
        String nickname = parts[1];
        String selfname = parts[2];
        try {
            weight = Long.parseLong(parts[3]);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Cannot parse value of weight from '" + parts[3] + "'", 3);
        }
        try {
            internalIp = InetAddress.getByName(parts[4]);
        }
        catch (UnknownHostException e) {
            throw new ParseException("Cannot parse ip address from '" + parts[4] + ",", 4);
        }
        try {
            internalPort = Integer.parseInt(parts[5]);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Cannot parse ip port from '" + parts[5] + "'", 5);
        }
        try {
            externalIp = InetAddress.getByName(parts[6]);
        }
        catch (UnknownHostException e) {
            throw new ParseException("Cannot parse ip address from '" + parts[6] + ",", 6);
        }
        try {
            externalPort = Integer.parseInt(parts[7]);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Cannot parse ip port from '" + parts[7] + "'", 7);
        }
        String memoToUse = parts.length == 9 ? parts[8] : memo;
        boolean isOwnHost = isOwnHostDeterminer.apply(internalIp);
        return new Address(id, nickname, selfname, weight, isOwnHost, internalIp.getAddress(), internalPort, externalIp.getAddress(), externalPort, memoToUse);
    }

    @NonNull
    public static AddressBook parseAddressBookConfigText(@NonNull String addressBookText, @NonNull Function<Long, NodeId> posToId, @NonNull Function<InetAddress, Boolean> isOwnDeterminer, @NonNull Function<NodeId, String> memoSource) throws ParseException {
        Objects.requireNonNull(addressBookText, "The addressBookText must not be null.");
        Objects.requireNonNull(posToId, "The posToId must not be null.");
        Objects.requireNonNull(isOwnDeterminer, "The isOwnDeterminer must not be null.");
        Objects.requireNonNull(memoSource, "The memoSource must not be null.");
        AddressBook addressBook = new AddressBook();
        long pos = 0L;
        for (String addressLine : addressBookText.split("\\r?\\n")) {
            NodeId id = posToId.apply(pos);
            addressBook.add(AddressBookUtils.parseAddressConfigText(addressLine, id, isOwnDeterminer, memoSource.apply(id)));
            ++pos;
        }
        return addressBook;
    }
}

