/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system.address;

import com.swirlds.common.system.NodeId;
import com.swirlds.common.system.address.Address;
import com.swirlds.common.system.address.AddressBook;
import com.swirlds.logging.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class AddressBookValidator {
    private static final Logger logger = LogManager.getLogger(AddressBookValidator.class);

    private AddressBookValidator() {
    }

    public static boolean hasNonZeroWeight(AddressBook addressBook) {
        if (addressBook.getTotalWeight() <= 0L) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "address book for round {} has {} total weight", (Object)addressBook.getRound(), (Object)addressBook.getTotalWeight());
            return false;
        }
        return true;
    }

    public static boolean isNonEmpty(AddressBook addressBook) {
        if (addressBook.getSize() == 0) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "address book for round {} is empty", (Object)addressBook.getRound());
            return false;
        }
        return true;
    }

    public static boolean validNextId(AddressBook previousAddressBook, AddressBook addressBook) {
        if (previousAddressBook.getNextNodeId().compareTo(addressBook.getNextNodeId()) > 0) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Invalid next node ID. Previous address book has a next node ID of {}, new address book has a next node ID of {}", (Object)previousAddressBook.getNextNodeId(), (Object)addressBook.getNextNodeId());
            return false;
        }
        return true;
    }

    public static boolean noAddressReinsertion(AddressBook previousAddressBook, AddressBook addressBook) {
        NodeId previousNextId = previousAddressBook.getNextNodeId();
        for (Address address : addressBook) {
            NodeId nodeId = address.getNodeId();
            if (nodeId.compareTo(previousNextId) >= 0 || previousAddressBook.contains(nodeId)) continue;
            logger.error(LogMarker.EXCEPTION.getMarker(), "Once an address is removed or a node ID is skipped, an address with that some node ID may never be added again. Invalid node ID = {}", (Object)nodeId);
            return false;
        }
        return true;
    }

    public static boolean isGenesisAddressBookValid(AddressBook candidateAddressBook) {
        return AddressBookValidator.hasNonZeroWeight(candidateAddressBook) && AddressBookValidator.isNonEmpty(candidateAddressBook);
    }

    public static boolean isNextAddressBookValid(AddressBook previousAddressBook, AddressBook candidateAddressBook) {
        return AddressBookValidator.hasNonZeroWeight(candidateAddressBook) && AddressBookValidator.isNonEmpty(candidateAddressBook) && AddressBookValidator.validNextId(previousAddressBook, candidateAddressBook) && AddressBookValidator.noAddressReinsertion(previousAddressBook, candidateAddressBook);
    }

    public static boolean sameExceptForWeight(@NonNull AddressBook addressBook1, @NonNull AddressBook addressBook2) {
        Objects.requireNonNull(addressBook1, "addressBook1 must not be null");
        Objects.requireNonNull(addressBook2, "addressBook2 must not be null");
        int addressBookSize = addressBook1.getSize();
        if (addressBookSize != addressBook2.getSize()) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Address books have different sizes. Address book 1 has size {}, address book 2 has size {}.", (Object)addressBookSize, (Object)addressBook2.getSize());
            return false;
        }
        return IntStream.range(0, addressBookSize).mapToObj(i -> {
            NodeId nodeId1 = addressBook1.getNodeId(i);
            NodeId nodeId2 = addressBook2.getNodeId(i);
            Address address1 = addressBook1.getAddress(nodeId1);
            Address address2 = addressBook2.getAddress(nodeId2);
            if (address1 == null || address2 == null) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "Address at index {} is null when accessed in order.", (Object)i);
                throw new IllegalStateException("Address at index " + i + " is null.");
            }
            boolean equal = address1.equalsWithoutWeightAndOwnHost(address2);
            if (!equal) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "Address at position {} is not the same between the two address books.", (Object)i);
            }
            return equal;
        }).reduce((left, right) -> left != false && right != false).orElse(false);
    }
}

