/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system.address.internal;

import com.swirlds.common.system.NodeId;
import com.swirlds.common.system.address.Address;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class AddressBookIterator
implements Iterator<Address> {
    private final Iterator<NodeId> orderedNodeIds;
    private final Map<NodeId, Address> addresses;

    public AddressBookIterator(@NonNull Iterator<NodeId> orderedNodeIds, @NonNull Map<NodeId, Address> addresses) {
        this.orderedNodeIds = Objects.requireNonNull(orderedNodeIds, "the orderedNodeIds cannot be null");
        this.addresses = Objects.requireNonNull(addresses, "the addresses cannot be null");
    }

    @Override
    public boolean hasNext() {
        return this.orderedNodeIds.hasNext();
    }

    @Override
    public Address next() {
        return Objects.requireNonNull(this.addresses.get(this.orderedNodeIds.next()));
    }
}

