/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system.events;

import com.swirlds.common.crypto.AbstractSerializableHashable;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.internal.SettingsCommon;
import com.swirlds.common.io.OptionalSelfSerializable;
import com.swirlds.common.io.SerializableWithKnownLength;
import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.system.SoftwareVersion;
import com.swirlds.common.system.events.EventSerializationOptions;
import com.swirlds.common.system.transaction.internal.ConsensusTransactionImpl;
import com.swirlds.common.utility.CommonUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class BaseEventHashedData
extends AbstractSerializableHashable
implements OptionalSelfSerializable<EventSerializationOptions> {
    public static final int TO_STRING_BYTE_ARRAY_LENGTH = 5;
    private static final long CLASS_ID = 2432614563609977411L;
    private SoftwareVersion softwareVersion;
    private long creatorId;
    private long selfParentGen;
    private long otherParentGen;
    private Hash selfParentHash;
    private Hash otherParentHash;
    private Instant timeCreated;
    private ConsensusTransactionImpl[] transactions;
    private boolean hasUserTransactions;

    public BaseEventHashedData() {
    }

    public BaseEventHashedData(@NonNull SoftwareVersion softwareVersion, long creatorId, long selfParentGen, long otherParentGen, @Nullable Hash selfParentHash, @Nullable Hash otherParentHash, @NonNull Instant timeCreated, @Nullable ConsensusTransactionImpl[] transactions) {
        this.softwareVersion = Objects.requireNonNull(softwareVersion, "The softwareVersion must not be null");
        this.creatorId = creatorId;
        this.selfParentGen = selfParentGen;
        this.otherParentGen = otherParentGen;
        this.selfParentHash = selfParentHash;
        this.otherParentHash = otherParentHash;
        this.timeCreated = Objects.requireNonNull(timeCreated, "The timeCreated must not be null");
        this.transactions = transactions;
        this.checkUserTransactions();
    }

    public BaseEventHashedData(@NonNull SoftwareVersion softwareVersion, long creatorId, long selfParentGen, long otherParentGen, @Nullable byte[] selfParentHash, @Nullable byte[] otherParentHash, @NonNull Instant timeCreated, @Nullable ConsensusTransactionImpl[] transactions) {
        this(softwareVersion, creatorId, selfParentGen, otherParentGen, selfParentHash == null ? null : new Hash(selfParentHash), otherParentHash == null ? null : new Hash(otherParentHash), timeCreated, transactions);
    }

    @Override
    public int getMinimumSupportedVersion() {
        return 2;
    }

    @Override
    public void serialize(SerializableDataOutputStream out, EventSerializationOptions option) throws IOException {
        out.writeSerializable(this.softwareVersion, true);
        out.writeLong(this.creatorId);
        out.writeLong(this.selfParentGen);
        out.writeLong(this.otherParentGen);
        out.writeSerializable(this.selfParentHash, false);
        out.writeSerializable(this.otherParentHash, false);
        out.writeInstant(this.timeCreated);
        if (option == EventSerializationOptions.OMIT_TRANSACTIONS) {
            out.writeInt(SerializableDataOutputStream.getSerializedLength(null, (boolean)true, (boolean)false));
            out.writeSerializableArray(null, true, false);
        } else {
            out.writeInt(SerializableDataOutputStream.getSerializedLength((SerializableWithKnownLength[])this.transactions, (boolean)true, (boolean)false));
            out.writeSerializableArray(this.transactions, true, false);
        }
    }

    @Override
    public void serialize(SerializableDataOutputStream out) throws IOException {
        this.serialize(out, EventSerializationOptions.FULL);
    }

    @Override
    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.deserialize(in, version, SettingsCommon.maxTransactionCountPerEvent);
    }

    public void deserialize(@NonNull SerializableDataInputStream in, int version, int maxTransactionCount) throws IOException {
        Objects.requireNonNull(in, "The input stream must not be null");
        this.softwareVersion = version >= 3 ? (SoftwareVersion)in.readSerializable() : SoftwareVersion.NO_VERSION;
        this.creatorId = in.readLong();
        this.selfParentGen = in.readLong();
        this.otherParentGen = in.readLong();
        this.selfParentHash = in.readSerializable(false, Hash::new);
        this.otherParentHash = in.readSerializable(false, Hash::new);
        this.timeCreated = in.readInstant();
        in.readInt();
        this.transactions = (ConsensusTransactionImpl[])in.readSerializableArray(ConsensusTransactionImpl[]::new, maxTransactionCount, true);
        this.checkUserTransactions();
    }

    private void checkUserTransactions() {
        if (this.transactions != null) {
            for (ConsensusTransactionImpl t : this.getTransactions()) {
                if (t.isSystem()) continue;
                this.hasUserTransactions = true;
                break;
            }
        }
    }

    public boolean hasUserTransactions() {
        return this.hasUserTransactions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseEventHashedData that = (BaseEventHashedData)o;
        return this.creatorId == that.creatorId && this.selfParentGen == that.selfParentGen && this.otherParentGen == that.otherParentGen && Objects.equals(this.selfParentHash, that.selfParentHash) && Objects.equals(this.otherParentHash, that.otherParentHash) && Objects.equals(this.timeCreated, that.timeCreated) && Arrays.equals(this.transactions, that.transactions) && Objects.equals(this.softwareVersion, that.softwareVersion);
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.softwareVersion).append(this.creatorId).append(this.selfParentGen).append(this.otherParentGen).append((Object)this.selfParentHash).append((Object)this.otherParentHash).append((Object)this.timeCreated).append((Object[])this.transactions).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("softwareVersion", (Object)this.softwareVersion).append("creatorId", this.creatorId).append("selfParentGen", this.selfParentGen).append("otherParentGen", this.otherParentGen).append("selfParentHash", (Object)CommonUtils.hex(this.valueOrNull(this.selfParentHash), 5)).append("otherParentHash", (Object)CommonUtils.hex(this.valueOrNull(this.otherParentHash), 5)).append("timeCreated", (Object)this.timeCreated).append("transactions size", this.transactions == null ? "null" : Integer.valueOf(this.transactions.length)).append("hash", (Object)CommonUtils.hex(this.valueOrNull(this.getHash()), 5)).toString();
    }

    private byte[] valueOrNull(Hash hash) {
        return hash == null ? null : hash.getValue();
    }

    @Override
    public long getClassId() {
        return 2432614563609977411L;
    }

    @Override
    public int getVersion() {
        return 3;
    }

    @Nullable
    public SoftwareVersion getSoftwareVersion() {
        return this.softwareVersion;
    }

    public long getCreatorId() {
        return this.creatorId;
    }

    public long getSelfParentGen() {
        return this.selfParentGen;
    }

    public long getOtherParentGen() {
        return this.otherParentGen;
    }

    public Hash getSelfParentHash() {
        return this.selfParentHash;
    }

    public Hash getOtherParentHash() {
        return this.otherParentHash;
    }

    public boolean hasSelfParent() {
        return this.selfParentHash != null;
    }

    public boolean hasOtherParent() {
        return this.otherParentHash != null;
    }

    public byte[] getSelfParentHashValue() {
        return this.selfParentHash == null ? null : this.selfParentHash.getValue();
    }

    public byte[] getOtherParentHashValue() {
        return this.otherParentHash == null ? null : this.otherParentHash.getValue();
    }

    public Instant getTimeCreated() {
        return this.timeCreated;
    }

    public ConsensusTransactionImpl[] getTransactions() {
        return this.transactions;
    }

    public long getGeneration() {
        return BaseEventHashedData.calculateGeneration(this.selfParentGen, this.otherParentGen);
    }

    public static long calculateGeneration(long selfParentGeneration, long otherParentGeneration) {
        return 1L + Math.max(selfParentGeneration, otherParentGeneration);
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;
        public static final int TRANSACTION_SUBCLASSES = 2;
        public static final int SOFTWARE_VERSION = 3;

        private ClassVersion() {
        }
    }
}

