/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system.events;

import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ConsensusData
implements SelfSerializable {
    private static final long CLASS_ID = -2453886215983421679L;
    private static final int CLASS_VERSION_ORIGINAL = 1;
    private static final int CLASS_VERSION_REMOVED_WITNESS_FAMOUS = 2;
    private static final int CLASS_VERSION = 2;
    public static final long NO_CONSENSUS = -1L;
    @Deprecated(forRemoval=true)
    private long generation = -1L;
    private long roundCreated = -1L;
    private boolean stale;
    private Instant consensusTimestamp;
    private long roundReceived = -1L;
    private long consensusOrder = -1L;
    private boolean lastInRoundReceived = false;

    @Override
    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeLong(this.generation);
        out.writeLong(this.roundCreated);
        out.writeBoolean(this.stale);
        out.writeBoolean(this.lastInRoundReceived);
        out.writeInstant(this.consensusTimestamp);
        out.writeLong(this.roundReceived);
        out.writeLong(this.consensusOrder);
    }

    @Override
    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.generation = in.readLong();
        this.roundCreated = in.readLong();
        if (version == 1) {
            in.readBoolean();
            in.readBoolean();
        }
        this.stale = in.readBoolean();
        this.lastInRoundReceived = in.readBoolean();
        this.consensusTimestamp = in.readInstant();
        this.roundReceived = in.readLong();
        this.consensusOrder = in.readLong();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsensusData that = (ConsensusData)o;
        return this.generation == that.generation && this.roundCreated == that.roundCreated && this.stale == that.stale && this.roundReceived == that.roundReceived && this.consensusOrder == that.consensusOrder && Objects.equals(this.consensusTimestamp, that.consensusTimestamp);
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.generation).append(this.roundCreated).append(this.stale).append(this.roundReceived).append(this.consensusOrder).append((Object)this.consensusTimestamp).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("generation", this.generation).append("roundCreated", this.roundCreated).append("stale", this.stale).append("consensusTimestamp", (Object)this.consensusTimestamp).append("roundReceived", this.roundReceived).append("consensusOrder", this.consensusOrder).append("lastInRoundReceived", this.lastInRoundReceived).toString();
    }

    @Deprecated(forRemoval=true)
    public void setGeneration(long generation) {
        this.generation = generation;
    }

    public long getRoundCreated() {
        return this.roundCreated;
    }

    public void setRoundCreated(long roundCreated) {
        this.roundCreated = roundCreated;
    }

    public boolean isStale() {
        return this.stale;
    }

    public void setStale(boolean stale) {
        this.stale = stale;
    }

    public Instant getConsensusTimestamp() {
        return this.consensusTimestamp;
    }

    public void setConsensusTimestamp(Instant consensusTimestamp) {
        this.consensusTimestamp = consensusTimestamp;
    }

    public long getRoundReceived() {
        return this.roundReceived;
    }

    public void setRoundReceived(long roundReceived) {
        this.roundReceived = roundReceived;
    }

    public long getConsensusOrder() {
        return this.consensusOrder;
    }

    public void setConsensusOrder(long consensusOrder) {
        this.consensusOrder = consensusOrder;
    }

    public boolean isLastInRoundReceived() {
        return this.lastInRoundReceived;
    }

    public void setLastInRoundReceived(boolean lastInRoundReceived) {
        this.lastInRoundReceived = lastInRoundReceived;
    }

    @Override
    public long getClassId() {
        return -2453886215983421679L;
    }

    @Override
    public int getVersion() {
        return 2;
    }
}

