/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading;

import com.swirlds.common.threading.locks.internal.AcquiredOnTry;
import com.swirlds.common.threading.locks.locked.MaybeLocked;
import com.swirlds.common.utility.CommonUtils;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;

public class SyncLock {
    private final Lock lock;
    private final Consumer<Boolean> onObtained;
    private final Consumer<Boolean> onClose;
    private final MaybeLocked outBoundObtained;
    private final MaybeLocked inBoundObtained;

    public SyncLock(Consumer<Boolean> onObtained, Consumer<Boolean> onClose) {
        this(new ReentrantLock(), onObtained, onClose);
    }

    public SyncLock(Lock lock, Consumer<Boolean> onObtained, Consumer<Boolean> onClose) {
        this.lock = CommonUtils.throwArgNull(lock, "lock");
        this.onObtained = CommonUtils.throwArgNull(onObtained, "onObtained");
        this.onClose = CommonUtils.throwArgNull(onClose, "onClose");
        this.outBoundObtained = new AcquiredOnTry(this::closeOutbound);
        this.inBoundObtained = new AcquiredOnTry(this::closeInbound);
    }

    public Lock getLock() {
        return this.lock;
    }

    private void closeOutbound() {
        this.onClose.accept(true);
        this.lock.unlock();
    }

    private void closeInbound() {
        this.onClose.accept(false);
        this.lock.unlock();
    }

    public MaybeLocked tryLock(boolean isOutbound) {
        if (this.lock.tryLock()) {
            this.onObtained.accept(isOutbound);
            return isOutbound ? this.outBoundObtained : this.inBoundObtained;
        }
        return MaybeLocked.NOT_ACQUIRED;
    }
}

