/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading;

import com.swirlds.common.threading.locks.internal.AcquiredOnTry;
import com.swirlds.common.threading.locks.locked.MaybeLocked;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.concurrent.Semaphore;

public class SyncPermitProvider {
    private final Semaphore syncPermits;
    private final AcquiredOnTry acquired;
    private final int numPermits;

    public SyncPermitProvider(int numPermits) {
        this.numPermits = numPermits;
        this.syncPermits = new Semaphore(numPermits);
        this.acquired = new AcquiredOnTry(this.syncPermits::release);
    }

    public int getNumAvailable() {
        return this.syncPermits.availablePermits();
    }

    @NonNull
    public MaybeLocked tryAcquire() {
        if (this.syncPermits.tryAcquire()) {
            return this.acquired;
        }
        return MaybeLocked.NOT_ACQUIRED;
    }

    public void waitForAllSyncsToFinish() {
        this.syncPermits.acquireUninterruptibly(this.numPermits);
        this.syncPermits.release(this.numPermits);
    }
}

