/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading.framework.config;

import com.swirlds.base.ArgumentUtils;
import com.swirlds.common.metrics.Metrics;
import com.swirlds.common.time.OSTime;
import com.swirlds.common.time.Time;
import edu.umd.cs.findbugs.annotations.NonNull;

public class QueueThreadMetricsConfiguration {
    private final Metrics metrics;
    private String category = "internal";
    private Time time = OSTime.getInstance();
    private boolean maxSizeMetricEnabled;
    private boolean minSizeMetricEnabled;
    private boolean busyTimeMetricEnabled;

    public QueueThreadMetricsConfiguration(@NonNull Metrics metrics) {
        this.metrics = (Metrics)ArgumentUtils.throwArgNull((Object)metrics, (String)"metrics");
    }

    @NonNull
    public QueueThreadMetricsConfiguration setCategory(@NonNull String category) {
        this.category = category;
        return this;
    }

    @NonNull
    public QueueThreadMetricsConfiguration setTime(@NonNull Time time) {
        this.time = time;
        return this;
    }

    @NonNull
    public QueueThreadMetricsConfiguration enableMaxSizeMetric() {
        this.maxSizeMetricEnabled = true;
        return this;
    }

    @NonNull
    public QueueThreadMetricsConfiguration enableMinSizeMetric() {
        this.minSizeMetricEnabled = true;
        return this;
    }

    @NonNull
    public QueueThreadMetricsConfiguration enableBusyTimeMetric() {
        this.busyTimeMetricEnabled = true;
        return this;
    }

    @NonNull
    public Metrics getMetrics() {
        return this.metrics;
    }

    @NonNull
    public String getCategory() {
        return this.category;
    }

    @NonNull
    public Time getTime() {
        return this.time;
    }

    public boolean isMaxSizeMetricEnabled() {
        return this.maxSizeMetricEnabled;
    }

    public boolean isMinSizeMetricEnabled() {
        return this.minSizeMetricEnabled;
    }

    public boolean isBusyTimeMetricEnabled() {
        return this.busyTimeMetricEnabled;
    }
}

