/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading.framework.internal;

import com.swirlds.base.state.Mutable;
import com.swirlds.common.Copyable;
import com.swirlds.common.system.NodeId;
import com.swirlds.common.threading.framework.ThreadSeed;
import com.swirlds.common.threading.framework.config.ThreadConfiguration;
import com.swirlds.common.threading.interrupt.InterruptableRunnable;
import com.swirlds.common.threading.manager.ThreadManager;
import com.swirlds.logging.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.LinkedList;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractThreadConfiguration<C extends AbstractThreadConfiguration<C>>
implements Copyable,
Mutable {
    private static final Logger logger = LogManager.getLogger(AbstractThreadConfiguration.class);
    private final ThreadManager threadManager;
    private NodeId nodeId;
    private String component;
    private String threadName;
    private String fullyFormattedThreadName;
    private Long otherNodeId;
    private ThreadGroup threadGroup = AbstractThreadConfiguration.defaultThreadGroup();
    private boolean useThreadNumbers;
    private final AtomicInteger nextThreadNumber;
    private boolean daemon = true;
    private int priority = 5;
    private ClassLoader contextClassLoader;
    private Thread.UncaughtExceptionHandler exceptionHandler;
    private Runnable runnable;
    private boolean immutable;

    protected AbstractThreadConfiguration(ThreadManager threadManager) {
        this.threadManager = threadManager;
        this.nextThreadNumber = new AtomicInteger();
    }

    protected AbstractThreadConfiguration(AbstractThreadConfiguration<C> that) {
        this.threadManager = that.threadManager;
        this.nodeId = that.nodeId;
        this.component = that.component;
        this.threadName = that.threadName;
        this.fullyFormattedThreadName = that.fullyFormattedThreadName;
        this.otherNodeId = that.otherNodeId;
        this.threadGroup = that.threadGroup;
        this.daemon = that.daemon;
        this.priority = that.priority;
        this.contextClassLoader = that.contextClassLoader;
        this.exceptionHandler = that.exceptionHandler;
        this.runnable = that.runnable;
        this.nextThreadNumber = that.nextThreadNumber;
        this.useThreadNumbers = that.useThreadNumbers;
    }

    protected ThreadManager getThreadManager() {
        return this.threadManager;
    }

    public abstract AbstractThreadConfiguration<C> copy();

    protected void becomeImmutable() {
        this.throwIfImmutable();
        this.immutable = true;
    }

    protected void copyThreadConfiguration(Thread thread) {
        this.setFullyFormattedThreadName(thread.getName());
        this.setDaemon(thread.isDaemon());
        this.setPriority(thread.getPriority());
        this.setExceptionHandler(thread.getUncaughtExceptionHandler());
        this.setContextClassLoader(thread.getContextClassLoader());
        this.setThreadGroup(thread.getThreadGroup());
    }

    protected Thread buildThread(boolean start) {
        Runnable runnable = Objects.requireNonNull(this.getRunnable(), "runnable must not be null");
        Thread thread = this.threadManager.createThread(this.getThreadGroup(), runnable);
        this.configureThread(thread);
        if (start) {
            thread.start();
        }
        return thread;
    }

    protected ThreadSeed buildThreadSeed() {
        Objects.requireNonNull(this.getRunnable(), "runnable must not be null");
        return () -> {
            ThreadConfiguration originalConfiguration = ThreadConfiguration.captureThreadConfiguration(this.threadManager);
            try {
                this.configureThread(Thread.currentThread());
                Objects.requireNonNull(this.getRunnable(), "runnable must not be null").run();
            }
            finally {
                originalConfiguration.configureThread(Thread.currentThread());
            }
        };
    }

    private static ThreadGroup defaultThreadGroup() {
        SecurityManager securityManager = System.getSecurityManager();
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getThreadGroup();
        }
        return securityManager.getThreadGroup();
    }

    private String buildThreadName() {
        boolean hasOtherNode;
        if (this.fullyFormattedThreadName != null) {
            return this.fullyFormattedThreadName;
        }
        LinkedList<Object> parts = new LinkedList<Object>();
        boolean hasComponent = this.component != null && !this.component.isBlank();
        boolean hasName = this.threadName != null && !this.threadName.isBlank();
        boolean hasNode = this.nodeId != null;
        boolean bl = hasOtherNode = this.otherNodeId != null;
        if (hasComponent) {
            parts.add(this.component + ":");
        }
        if (hasName) {
            parts.add(this.threadName);
        } else {
            parts.add("unnamed");
        }
        if (hasNode) {
            parts.add(this.nodeId.toString());
        }
        if (hasOtherNode) {
            if (hasNode) {
                parts.add("to");
            } else {
                parts.add("? to");
            }
            parts.add(Long.toString(this.otherNodeId));
        }
        if (this.useThreadNumbers) {
            parts.add("#" + this.nextThreadNumber.getAndIncrement());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        for (int index = 0; index < parts.size(); ++index) {
            sb.append((String)parts.get(index));
            if (index + 1 >= parts.size()) continue;
            sb.append(" ");
        }
        sb.append(">");
        return sb.toString();
    }

    private static Thread.UncaughtExceptionHandler buildDefaultExceptionHandler() {
        return (t, e) -> logger.error(LogMarker.EXCEPTION.getMarker(), "exception on thread {}", (Object)t.getName(), (Object)e);
    }

    protected void configureThread(Thread thread) {
        thread.setName(this.buildThreadName());
        if (!thread.isAlive()) {
            thread.setDaemon(this.isDaemon());
        }
        thread.setPriority(this.getPriority());
        thread.setUncaughtExceptionHandler(this.getExceptionHandler());
        if (this.getContextClassLoader() != null) {
            thread.setContextClassLoader(this.getContextClassLoader());
        }
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public C setThreadGroup(ThreadGroup threadGroup) {
        this.throwIfImmutable();
        this.threadGroup = threadGroup;
        return (C)this;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public C setDaemon(boolean daemon) {
        this.throwIfImmutable();
        this.daemon = daemon;
        return (C)this;
    }

    public int getPriority() {
        return this.priority;
    }

    public C setPriority(int priority) {
        this.throwIfImmutable();
        this.priority = priority;
        return (C)this;
    }

    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }

    public C setContextClassLoader(ClassLoader contextClassLoader) {
        this.throwIfImmutable();
        this.contextClassLoader = contextClassLoader;
        return (C)this;
    }

    public Thread.UncaughtExceptionHandler getExceptionHandler() {
        return this.exceptionHandler == null ? AbstractThreadConfiguration.buildDefaultExceptionHandler() : this.exceptionHandler;
    }

    public C setExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        this.throwIfImmutable();
        this.exceptionHandler = exceptionHandler;
        return (C)this;
    }

    @NonNull
    public NodeId getNodeId() {
        return this.nodeId;
    }

    public C setNodeId(@NonNull NodeId nodeId) {
        this.throwIfImmutable();
        Objects.requireNonNull(nodeId, "nodeId must not be null");
        this.nodeId = nodeId;
        return (C)this;
    }

    public String getComponent() {
        return this.component;
    }

    public C setComponent(String component) {
        this.throwIfImmutable();
        this.component = component;
        return (C)this;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public C setThreadName(String threadName) {
        this.throwIfImmutable();
        this.threadName = threadName;
        return (C)this;
    }

    public String getFullyFormattedThreadName() {
        return this.fullyFormattedThreadName;
    }

    public C setFullyFormattedThreadName(String fullyFormattedThreadName) {
        this.throwIfImmutable();
        this.fullyFormattedThreadName = fullyFormattedThreadName;
        return (C)this;
    }

    public Long getOtherNodeId() {
        return this.otherNodeId;
    }

    public C setOtherNodeId(Long otherNodeId) {
        this.throwIfImmutable();
        this.otherNodeId = otherNodeId;
        return (C)this;
    }

    protected Runnable getRunnable() {
        return this.runnable;
    }

    protected C setRunnable(Runnable runnable) {
        this.throwIfImmutable();
        this.runnable = runnable;
        return (C)this;
    }

    public C setInterruptableRunnable(InterruptableRunnable runnable) {
        this.throwIfImmutable();
        this.runnable = () -> {
            try {
                runnable.run();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        };
        return (C)this;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    protected void enableThreadNumbering() {
        this.throwIfImmutable();
        this.useThreadNumbers = true;
    }
}

