/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading.framework.internal;

import com.swirlds.common.metrics.IntegerAccumulator;
import com.swirlds.common.metrics.Metrics;
import com.swirlds.common.threading.framework.internal.AbstractBlockingQueue;
import com.swirlds.common.utility.CommonUtils;
import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

class MeasuredBlockingQueue<T>
extends AbstractBlockingQueue<T> {
    static final String QUEUE_MAX_SIZE_SUFFIX = "-queueMaxSize";
    static final String QUEUE_MIN_SIZE_SUFFIX = "-queueMinSize";
    private final IntegerAccumulator maxSizeMetric;
    private final IntegerAccumulator minSizeMetric;

    public MeasuredBlockingQueue(BlockingQueue<T> queue, Config config) {
        super(queue);
        String description;
        String name;
        CommonUtils.throwArgNull(queue, "queue");
        CommonUtils.throwArgNull(config, "config");
        if (!config.isMetricEnabled()) {
            throw new IllegalStateException("No metrics have been enabled for the queue '" + config.queueName + "'");
        }
        if (config.maxSizeMetricEnabled) {
            name = config.queueName + QUEUE_MAX_SIZE_SUFFIX;
            description = String.format("the maximum size during a sampling period of the queue %s", config.queueName);
            this.maxSizeMetric = config.metrics.getOrCreate(new IntegerAccumulator.Config(config.category, name).withDescription(description).withFormat("%d").withAccumulator(Math::max).withInitializer(queue::size));
        } else {
            this.maxSizeMetric = null;
        }
        if (config.minSizeMetricEnabled) {
            name = config.queueName + QUEUE_MIN_SIZE_SUFFIX;
            description = String.format("the minimum size during a sampling period of the queue %s", config.queueName);
            this.minSizeMetric = config.metrics.getOrCreate(new IntegerAccumulator.Config(config.category, name).withDescription(description).withFormat("%d").withAccumulator(Math::min).withInitializer(queue::size));
        } else {
            this.minSizeMetric = null;
        }
    }

    private void updateMetrics() {
        if (this.maxSizeMetric != null) {
            this.maxSizeMetric.update(super.size());
        }
        if (this.minSizeMetric != null) {
            this.minSizeMetric.update(super.size());
        }
    }

    @Override
    public boolean add(T t) {
        boolean changed = super.add(t);
        if (changed) {
            this.updateMetrics();
        }
        return changed;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean changed = super.addAll(c);
        if (changed) {
            this.updateMetrics();
        }
        return changed;
    }

    @Override
    public boolean offer(T t) {
        boolean changed = super.offer(t);
        if (changed) {
            this.updateMetrics();
        }
        return changed;
    }

    @Override
    public boolean offer(T t, long timeout, TimeUnit unit) throws InterruptedException {
        boolean changed = super.offer(t, timeout, unit);
        if (changed) {
            this.updateMetrics();
        }
        return changed;
    }

    @Override
    public void put(T t) throws InterruptedException {
        super.put(t);
        this.updateMetrics();
    }

    @Override
    public T poll() {
        Object t = super.poll();
        this.updateMetrics();
        return t;
    }

    @Override
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        Object t = super.poll(timeout, unit);
        this.updateMetrics();
        return t;
    }

    @Override
    public T remove() {
        Object t = super.remove();
        this.updateMetrics();
        return t;
    }

    @Override
    public boolean remove(Object o) {
        boolean changed = super.remove(o);
        if (changed) {
            this.updateMetrics();
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = super.removeAll(c);
        if (changed) {
            this.updateMetrics();
        }
        return changed;
    }

    @Override
    public T take() throws InterruptedException {
        Object t = super.take();
        this.updateMetrics();
        return t;
    }

    @Override
    public int drainTo(Collection<? super T> c) {
        int num = super.drainTo(c);
        this.updateMetrics();
        return num;
    }

    @Override
    public int drainTo(Collection<? super T> c, int maxElements) {
        int num = super.drainTo(c, maxElements);
        this.updateMetrics();
        return num;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = super.retainAll(c);
        if (changed) {
            this.updateMetrics();
        }
        return changed;
    }

    @Override
    public void clear() {
        super.clear();
        this.updateMetrics();
    }

    static final class Config {
        private final Metrics metrics;
        private final String category;
        private final String queueName;
        private final boolean maxSizeMetricEnabled;
        private final boolean minSizeMetricEnabled;

        public Config(Metrics metrics, String category, String queueName) {
            this(metrics, category, queueName, false, false);
        }

        private Config(Metrics metrics, String category, String queueName, boolean maxSizeMetricEnabled, boolean minSizeMetricEnabled) {
            CommonUtils.throwArgNull(metrics, "metrics");
            CommonUtils.throwArgNull(category, "category");
            CommonUtils.throwArgNull(queueName, "queueName");
            this.metrics = metrics;
            this.category = category;
            this.queueName = queueName;
            this.maxSizeMetricEnabled = maxSizeMetricEnabled;
            this.minSizeMetricEnabled = minSizeMetricEnabled;
        }

        public Config withMaxSizeMetricEnabled(boolean enabled) {
            return new Config(this.getMetrics(), this.getCategory(), this.getQueueName(), enabled, this.isMinSizeMetricEnabled());
        }

        public Config withMinSizeMetricEnabled(boolean enabled) {
            return new Config(this.getMetrics(), this.getCategory(), this.getQueueName(), this.isMaxSizeMetricEnabled(), enabled);
        }

        public Metrics getMetrics() {
            return this.metrics;
        }

        public String getCategory() {
            return this.category;
        }

        public String getQueueName() {
            return this.queueName;
        }

        public boolean isMaxSizeMetricEnabled() {
            return this.maxSizeMetricEnabled;
        }

        public boolean isMinSizeMetricEnabled() {
            return this.minSizeMetricEnabled;
        }

        public boolean isMetricEnabled() {
            return this.maxSizeMetricEnabled || this.minSizeMetricEnabled;
        }
    }
}

