/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading.interrupt;

import com.swirlds.base.function.CheckedConsumer;
import com.swirlds.common.threading.interrupt.InterruptableRunnable;
import com.swirlds.common.threading.interrupt.InterruptableSupplier;
import com.swirlds.logging.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Uninterruptable {
    private static final Logger logger = LogManager.getLogger(Uninterruptable.class);

    private Uninterruptable() {
    }

    public static void retryIfInterrupted(@NonNull InterruptableRunnable action) {
        Objects.requireNonNull(action, "action");
        boolean finished = false;
        boolean interrupted = false;
        while (!finished) {
            try {
                action.run();
                finished = true;
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    @Nullable
    public static <T> T retryIfInterrupted(@NonNull InterruptableSupplier<T> action) {
        Objects.requireNonNull(action, "action");
        boolean finished = false;
        boolean interrupted = false;
        T value = null;
        while (!finished) {
            try {
                value = action.get();
                finished = true;
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return value;
    }

    public static void abortIfInterrupted(@NonNull InterruptableRunnable action) {
        Objects.requireNonNull(action, "action");
        try {
            action.run();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void abortAndLogIfInterrupted(@NonNull InterruptableRunnable action, @NonNull String errorMessage) {
        Objects.requireNonNull(action, "action");
        try {
            action.run();
        }
        catch (InterruptedException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), errorMessage);
            Thread.currentThread().interrupt();
        }
    }

    public static <T> void abortAndLogIfInterrupted(@NonNull CheckedConsumer<T, InterruptedException> consumer, @Nullable T object, @NonNull String errorMessage) {
        Objects.requireNonNull(consumer, "consumer");
        Objects.requireNonNull(errorMessage, "errorMessage");
        try {
            consumer.accept(object);
        }
        catch (InterruptedException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), errorMessage);
            Thread.currentThread().interrupt();
        }
    }

    public static void abortAndThrowIfInterrupted(@NonNull InterruptableRunnable action, @NonNull String errorMessage) {
        Objects.requireNonNull(action, "action");
        try {
            action.run();
        }
        catch (InterruptedException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), errorMessage);
            Thread.currentThread().interrupt();
            throw new IllegalStateException(errorMessage);
        }
    }

    public static <T> void abortAndThrowIfInterrupted(@NonNull CheckedConsumer<T, InterruptedException> consumer, @Nullable T object, @NonNull String errorMessage) {
        Objects.requireNonNull(consumer, "consumer");
        Objects.requireNonNull(errorMessage, "errorMessage");
        try {
            consumer.accept(object);
        }
        catch (InterruptedException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), errorMessage);
            Thread.currentThread().interrupt();
            throw new IllegalStateException(errorMessage);
        }
    }

    public static void tryToSleep(@NonNull Duration duration) {
        Uninterruptable.abortIfInterrupted(() -> TimeUnit.MILLISECONDS.sleep(duration.toMillis()));
    }
}

