/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.units;

import com.swirlds.common.units.Unit;
import com.swirlds.common.units.UnitConverter;

public enum FrequencyUnit implements Unit<FrequencyUnit>
{
    UNIT_HERTZ(1, "hertz", "Hz"),
    UNIT_KILOHERTZ(1000, "kilohertz", "kHz"),
    UNIT_MEGAHERTZ(1000, "megahertz", "MHz"),
    UNIT_GIGAHERTZ(1000, "gigahertz", "GHz"),
    UNIT_TERAHERTZ(1000, "terahertz", "THz");

    private static final UnitConverter<FrequencyUnit> converter;
    private final int conversionFactor;
    private final String name;
    private final String abbreviation;

    private FrequencyUnit(int conversionFactor, String name, String abbreviation) {
        this.conversionFactor = conversionFactor;
        this.name = name;
        this.abbreviation = abbreviation;
    }

    @Override
    public Unit.SimplifiedQuantity<FrequencyUnit> simplify(double quantity) {
        return converter.simplify(quantity, this);
    }

    @Override
    public double convertTo(double quantity, FrequencyUnit to) {
        return converter.convertTo(quantity, this, to);
    }

    @Override
    public double convertTo(long quantity, FrequencyUnit to) {
        return converter.convertTo(quantity, this, to);
    }

    @Override
    public int getConversionFactor() {
        return this.conversionFactor;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPluralName() {
        return this.name;
    }

    @Override
    public String getAbbreviation() {
        return this.abbreviation;
    }

    static {
        converter = new UnitConverter((Unit[])FrequencyUnit.values());
    }
}

