/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.utility;

import com.swirlds.common.Reservable;
import com.swirlds.common.exceptions.ReferenceCountException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;

public abstract class AbstractReservable
implements Reservable {
    private final AtomicInteger reservationCount = new AtomicInteger(0);
    private final IntUnaryOperator RESERVE = current -> {
        if (current == -1) {
            this.onReferenceCountException();
            throw new ReferenceCountException("can not reserve node that has already been destroyed");
        }
        return current + 1;
    };
    private static final IntUnaryOperator TRY_RESERVE = current -> {
        if (current == -1) {
            return current;
        }
        return current + 1;
    };
    private final IntUnaryOperator RELEASE = current -> {
        if (current == -1) {
            this.onReferenceCountException();
            throw new ReferenceCountException("can not release node that has already been destroyed");
        }
        if (current == 0 || current == 1) {
            return -1;
        }
        return current - 1;
    };

    @Override
    public void reserve() {
        this.reservationCount.updateAndGet(this.RESERVE);
    }

    @Override
    public boolean tryReserve() {
        return this.reservationCount.updateAndGet(TRY_RESERVE) != -1;
    }

    @Override
    public boolean release() {
        int newReservationCount = this.reservationCount.updateAndGet(this.RELEASE);
        if (newReservationCount == -1) {
            this.onDestroy();
            return true;
        }
        return false;
    }

    @Override
    public boolean isDestroyed() {
        return this.reservationCount.get() == -1;
    }

    @Override
    public int getReservationCount() {
        return this.reservationCount.get();
    }

    protected void onDestroy() {
    }

    protected void onReferenceCountException() {
    }

    @Override
    public void throwIfDestroyed(@NonNull String errorMessage) {
        this.onReferenceCountException();
        Reservable.super.throwIfDestroyed(errorMessage);
    }
}

