/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.utility;

import com.swirlds.base.function.CheckedFunction;
import com.swirlds.common.utility.CommonUtils;
import java.util.NoSuchElementException;
import java.util.function.LongToIntFunction;

public final class BinarySearch {
    private BinarySearch() {
    }

    public static long search(long minimumIndex, long maximumIndex, LongToIntFunction compareToDesired) {
        CommonUtils.throwArgNull(compareToDesired, "compareToDesired");
        return BinarySearch.throwingSearch(minimumIndex, maximumIndex, compareToDesired::applyAsInt);
    }

    public static <E extends Exception> long throwingSearch(long minimumIndex, long maximumIndex, CheckedFunction<Long, Integer, E> compareToDesired) throws E {
        if (minimumIndex >= maximumIndex) {
            throw new IllegalArgumentException("maximum index must be strictly greater than the minimum index");
        }
        CommonUtils.throwArgNull(compareToDesired, "compareToDesired");
        long leftBoundary = minimumIndex;
        long rightBoundary = maximumIndex - 1L;
        if ((Integer)compareToDesired.apply((Object)leftBoundary) > 0) {
            throw new NoSuchElementException("Requested value is not in the specified range");
        }
        if ((Integer)compareToDesired.apply((Object)rightBoundary) < 0) {
            return rightBoundary;
        }
        long middleIndex;
        int comparison;
        while ((comparison = ((Integer)compareToDesired.apply((Object)(middleIndex = leftBoundary + (rightBoundary - leftBoundary) / 2L))).intValue()) != 0) {
            if (middleIndex == leftBoundary) {
                if ((Integer)compareToDesired.apply((Object)rightBoundary) == 0) {
                    return rightBoundary;
                }
                return leftBoundary;
            }
            if (comparison < 0) {
                leftBoundary = middleIndex;
                continue;
            }
            rightBoundary = middleIndex;
        }
        return middleIndex;
    }
}

