/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.utility;

import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.system.SoftwareVersion;
import com.swirlds.common.utility.CommonUtils;
import com.swirlds.common.utility.InvalidSemanticVersionException;
import com.swirlds.common.utility.SemanticVersion;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public final class PlatformVersion
implements SoftwareVersion {
    public static final PlatformVersion ZERO = new PlatformVersion(SemanticVersion.ZERO, "");
    private static final String GIT_PROPERTIES_FILE = "git.properties";
    private static final String GIT_BUILD_VERSION = "git.build.version";
    private static final String GIT_COMMIT_ID = "git.commit.id.full";
    private static final String LICENSE_TEMPLATE = "Swirlds browser v. %s (commit: %s)\n(c)2016-2022 Swirlds Inc\nThis is an early alpha version.\nThe Swirlds\u2122 software is covered by one or more patents\n(see www.swirlds.com/ip). The browser is free to download,\nto experiment with, and to test in building apps. To deploy\nor use those apps, contact sales@swirlds.com";
    private static final long CLASS_ID = 9192029045640773809L;
    private static final int COMMIT_MAX_LENGTH = 200;
    private SemanticVersion versionNumber;
    private String commit;

    public PlatformVersion() {
    }

    public PlatformVersion(SemanticVersion versionNumber, String commit) {
        this.versionNumber = versionNumber;
        this.commit = commit;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static PlatformVersion fromJarFile(Path file) {
        CommonUtils.throwArgNull(file, "file");
        try (JarFile jarFile = new JarFile(file.toFile());){
            PlatformVersion platformVersion;
            block14: {
                ZipEntry ze = jarFile.getEntry(GIT_PROPERTIES_FILE);
                if (ze == null || ze.isDirectory()) {
                    throw new InvalidSemanticVersionException(String.format("The JAR file did not contain a valid version descriptor: %s", file));
                }
                InputStream inputStream = jarFile.getInputStream(ze);
                try {
                    platformVersion = PlatformVersion.fromStream(inputStream);
                    if (inputStream == null) break block14;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return platformVersion;
        }
        catch (IOException e) {
            throw new InvalidSemanticVersionException(String.format("Unable to read the JAR file: %s", file), e);
        }
    }

    public static PlatformVersion fromStream(InputStream stream) throws IOException {
        CommonUtils.throwArgNull(stream, "stream");
        Properties properties = new Properties();
        properties.load(stream);
        return PlatformVersion.fromProperties(properties);
    }

    public static PlatformVersion fromProperties(Properties properties) {
        CommonUtils.throwArgNull(properties, "properties");
        String versionString = properties.getProperty(GIT_BUILD_VERSION);
        String commitId = CommonUtils.nullToBlank(properties.getProperty(GIT_COMMIT_ID));
        if (versionString == null || versionString.isBlank()) {
            throw new InvalidSemanticVersionException(String.format("The version descriptor is missing the mandatory property: %s", GIT_BUILD_VERSION));
        }
        return new PlatformVersion(SemanticVersion.parse(versionString), commitId);
    }

    public static PlatformVersion fromClassLoader(ClassLoader loader) {
        PlatformVersion platformVersion;
        block9: {
            CommonUtils.throwArgNull(loader, "loader");
            InputStream inputStream = loader.getResourceAsStream(GIT_PROPERTIES_FILE);
            try {
                if (inputStream == null) {
                    throw new InvalidSemanticVersionException("Unable to locate a valid version descriptor via the ClassLoader");
                }
                platformVersion = PlatformVersion.fromStream(inputStream);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new InvalidSemanticVersionException("Failed to read the version descriptor from the class path", e);
                }
            }
            inputStream.close();
        }
        return platformVersion;
    }

    public static PlatformVersion locate() {
        return PlatformVersion.locate(PlatformVersion.class);
    }

    public static PlatformVersion locate(Class<?> sourceClass) {
        CommonUtils.throwArgNull(sourceClass, "sourceClass");
        ClassLoader classLoader = sourceClass.getClassLoader();
        return PlatformVersion.fromClassLoader(classLoader);
    }

    public static PlatformVersion locateOrDefault() {
        return PlatformVersion.locateOrDefault(ZERO);
    }

    public static PlatformVersion locateOrDefault(PlatformVersion defaultVersion) {
        return PlatformVersion.locateOrDefault(PlatformVersion.class, defaultVersion);
    }

    public static PlatformVersion locateOrDefault(Class<?> sourceClass, PlatformVersion defaultVersion) {
        CommonUtils.throwArgNull(sourceClass, "sourceClass");
        try {
            return PlatformVersion.locate(sourceClass);
        }
        catch (InvalidSemanticVersionException ignored) {
            return defaultVersion;
        }
    }

    public String license() {
        return String.format(LICENSE_TEMPLATE, this.versionNumber(), this.commit());
    }

    public SemanticVersion versionNumber() {
        return this.versionNumber;
    }

    public String commit() {
        return this.commit;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PlatformVersion that = (PlatformVersion)obj;
        return Objects.equals(this.versionNumber, that.versionNumber) && Objects.equals(this.commit, that.commit);
    }

    public int hashCode() {
        return Objects.hash(this.versionNumber, this.commit);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("versionNumber", (Object)this.versionNumber).append("commit", (Object)this.commit).toString();
    }

    @Override
    public long getClassId() {
        return 9192029045640773809L;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeSerializable(this.versionNumber, false);
        out.writeNormalisedString(this.commit);
    }

    @Override
    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.versionNumber = in.readSerializable(false, SemanticVersion::new);
        this.commit = in.readNormalisedString(200);
    }

    @Override
    public int compareTo(SoftwareVersion that) {
        if (this == that) {
            return 0;
        }
        if (!(that instanceof PlatformVersion)) {
            return -1;
        }
        PlatformVersion pv = (PlatformVersion)that;
        return new CompareToBuilder().append((Object)this.versionNumber, (Object)pv.versionNumber).append((Object)this.commit, (Object)pv.commit).build();
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

