/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.utility;

import com.swirlds.common.utility.RuntimeObjectRecord;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class RuntimeObjectRegistry {
    private static final Map<Class<?>, List<RuntimeObjectRecord>> RECORDS = new ConcurrentHashMap();

    private RuntimeObjectRegistry() {
    }

    public static <T> RuntimeObjectRecord createRecord(Class<T> cls) {
        return RuntimeObjectRegistry.createRecord(cls, null);
    }

    public static <T> RuntimeObjectRecord createRecord(Class<T> cls, Object metadata) {
        Instant now = Instant.now();
        List classRecords = RECORDS.computeIfAbsent(cls, clsid -> Collections.synchronizedList(new ArrayList()));
        RuntimeObjectRecord objectRecord = new RuntimeObjectRecord(now, classRecords::remove, metadata);
        classRecords.add(objectRecord);
        return objectRecord;
    }

    public static <T> int getActiveObjectsCount(Class<T> cls) {
        List<RuntimeObjectRecord> classRecords = RECORDS.get(cls);
        return classRecords != null ? classRecords.size() : 0;
    }

    public static <T> Duration getOldestActiveObjectAge(Class<T> cls, Instant now) {
        List<RuntimeObjectRecord> classRecords = RECORDS.get(cls);
        if (classRecords == null) {
            return Duration.ZERO;
        }
        try {
            RuntimeObjectRecord oldestRecord = classRecords.get(0);
            return oldestRecord.getAge(now);
        }
        catch (IndexOutOfBoundsException e) {
            return Duration.ZERO;
        }
    }

    public static <T> RuntimeObjectRecord getOldestActiveObjectRecord(Class<T> cls) {
        List<RuntimeObjectRecord> classRecords = RECORDS.get(cls);
        if (classRecords == null) {
            return null;
        }
        try {
            return classRecords.get(0);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public static Set<Class<?>> getTrackedClasses() {
        return Collections.unmodifiableSet(RECORDS.keySet());
    }

    public static void reset() {
        RECORDS.clear();
    }
}

