/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.config;

import com.swirlds.common.config.validators.DefaultConfigViolation;
import com.swirlds.config.api.ConfigData;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.validation.ConfigViolation;

@ConfigData(value="transaction")
public record TransactionConfig(int transactionMaxBytes, int maxAddressSizeAllowed, int maxTransactionBytesPerEvent, int maxTransactionCountPerEvent, int throttleTransactionQueueSize) {
    public ConfigViolation validateTransactionBytes(Configuration configuration) {
        TransactionConfig transactionConfig = (TransactionConfig)configuration.getConfigData(TransactionConfig.class);
        int transactionMaxBytes = transactionConfig.transactionMaxBytes();
        int maxTransactionBytesPerEvent = transactionConfig.maxTransactionBytesPerEvent();
        if (maxTransactionBytesPerEvent < transactionMaxBytes) {
            return new DefaultConfigViolation("transactionMaxBytes", "" + transactionMaxBytes, true, "Cannot configure transactionMaxBytes to " + transactionMaxBytes + ", it must be < " + maxTransactionBytesPerEvent);
        }
        return null;
    }
}

