/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.config.sources;

import com.swirlds.common.utility.CommonUtils;
import com.swirlds.config.api.source.ConfigSource;
import java.util.NoSuchElementException;
import java.util.Set;

public final class SystemPropertiesConfigSource
implements ConfigSource {
    private static SystemPropertiesConfigSource instance;

    private SystemPropertiesConfigSource() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SystemPropertiesConfigSource getInstance() {
        if (instance != null) return instance;
        Class<SystemPropertiesConfigSource> clazz = SystemPropertiesConfigSource.class;
        synchronized (SystemPropertiesConfigSource.class) {
            if (instance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            instance = new SystemPropertiesConfigSource();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Set<String> getPropertyNames() {
        return System.getProperties().stringPropertyNames();
    }

    public String getValue(String propertyName) {
        CommonUtils.throwArgBlank(propertyName, "propertyName");
        if (!this.getPropertyNames().contains(propertyName)) {
            throw new NoSuchElementException("Property " + propertyName + " is not defined");
        }
        return System.getProperty(propertyName);
    }

    public int getOrdinal() {
        return 400;
    }
}

