/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.crypto;

import com.swirlds.common.crypto.CryptographyException;
import com.swirlds.common.crypto.DigestType;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.crypto.ImmutableHash;
import com.swirlds.common.crypto.InvalidDigestTypeException;
import com.swirlds.logging.LogMarker;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Objects;

public class HashBuilder {
    private MessageDigest digest;
    private DigestType digestType;

    public HashBuilder(MessageDigest digest) {
        if (digest == null) {
            throw new IllegalArgumentException("digest");
        }
        this.digest = digest;
        this.detectDigestType();
    }

    public HashBuilder(DigestType digestType) {
        if (digestType == null) {
            throw new IllegalArgumentException("digestType");
        }
        this.digestType = digestType;
        this.initializeDigest();
    }

    public HashBuilder update(long n) {
        for (int i = 0; i < 8; ++i) {
            this.digest.update((byte)(n & 0xFFL));
            n >>= 8;
        }
        return this;
    }

    public HashBuilder update(int n) {
        for (int i = 0; i < 4; ++i) {
            this.digest.update((byte)(n & 0xFF));
            n >>= 8;
        }
        return this;
    }

    public HashBuilder update(byte[] t, int offset, int length) {
        if (t == null) {
            this.update(0);
        } else {
            this.update(t.length);
            this.digest.update(t, offset, length);
        }
        return this;
    }

    public HashBuilder update(Instant i) {
        this.update(i.getEpochSecond());
        this.update(i.getNano());
        return this;
    }

    public HashBuilder update(byte[][] t) {
        if (t == null) {
            this.update(0);
        } else {
            this.update(t.length);
            for (byte[] a : t) {
                if (a == null) {
                    this.update(0);
                    continue;
                }
                this.update(a.length);
                this.digest.update(a);
            }
        }
        return this;
    }

    public HashBuilder update(byte[] t) {
        if (t == null) {
            this.update(0);
        } else {
            this.update(t.length);
            this.digest.update(t);
        }
        return this;
    }

    public HashBuilder update(Hash hash) {
        if (hash == null) {
            throw new IllegalArgumentException("hash");
        }
        this.digest.update(hash.getValue());
        return this;
    }

    public HashBuilder updateRaw(byte[] data) {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("data");
        }
        this.digest.update(data);
        return this;
    }

    public HashBuilder reset() {
        this.digest.reset();
        return this;
    }

    public Hash build() {
        return this.mutable();
    }

    public Hash mutable() {
        return new Hash(this.digest.digest(), this.digestType);
    }

    public ImmutableHash immutable() {
        return new ImmutableHash(this.digest.digest(), this.digestType);
    }

    private void initializeDigest() {
        try {
            this.digest = MessageDigest.getInstance(this.digestType.algorithmName());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CryptographyException(ex, LogMarker.EXCEPTION);
        }
    }

    private void detectDigestType() {
        for (DigestType t : DigestType.values()) {
            if (!Objects.equals(t.algorithmName(), this.digest.getAlgorithm())) continue;
            this.digestType = t;
            break;
        }
        if (this.digestType == null) {
            throw new InvalidDigestTypeException(this.digest.getAlgorithm());
        }
    }
}

