/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.crypto;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;

public class HashingOutputStream
extends OutputStream {
    OutputStream out = null;
    MessageDigest md;

    public HashingOutputStream(MessageDigest md) {
        this.md = md;
    }

    public HashingOutputStream(MessageDigest md, OutputStream out) {
        this.out = out;
        this.md = md;
    }

    @Override
    public void write(int arg0) throws IOException {
        this.md.update((byte)arg0);
        if (this.out != null) {
            this.out.write(arg0);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.md.update(b, off, len);
        if (this.out != null) {
            this.out.write(b, off, len);
        }
    }

    public void resetDigest() {
        this.md.reset();
    }

    public byte[] getDigest() {
        return this.md.digest();
    }
}

