/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.crypto;

import java.security.PublicKey;

public enum KeyType {
    EC(1, "SunEC"),
    RSA(2, "BC");

    private final int algorithmIdentifier;
    private final String provider;

    private KeyType(int algorithmIdentifier, String provider) {
        this.algorithmIdentifier = algorithmIdentifier;
        this.provider = provider;
    }

    String getAlgorithmName() {
        return this.name();
    }

    public int getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    public String getProvider() {
        return this.provider;
    }

    static KeyType getKeyType(int algorithmIdentifier) {
        switch (algorithmIdentifier) {
            case 1: {
                return EC;
            }
            case 2: {
                return RSA;
            }
        }
        return null;
    }

    static KeyType getKeyType(PublicKey key) {
        switch (key.getAlgorithm()) {
            case "EC": {
                return EC;
            }
            case "RSA": {
                return RSA;
            }
        }
        throw new IllegalArgumentException(key.getAlgorithm() + " is not a known key type!");
    }
}

