/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.crypto.engine;

import com.swirlds.common.crypto.SignatureType;
import com.swirlds.common.crypto.TransactionSignature;
import com.swirlds.common.crypto.VerificationStatus;
import com.swirlds.common.crypto.engine.AsyncOperationHandler;
import com.swirlds.common.crypto.engine.OperationProvider;
import java.security.NoSuchAlgorithmException;
import java.util.List;

public class AsyncVerificationHandler
extends AsyncOperationHandler<TransactionSignature, OperationProvider<TransactionSignature, Void, Boolean, ?, SignatureType>> {
    public AsyncVerificationHandler(List<TransactionSignature> workItems, OperationProvider<TransactionSignature, Void, Boolean, ?, SignatureType> provider) {
        super(workItems, provider);
    }

    public AsyncVerificationHandler(List<TransactionSignature> workItems, boolean shouldCopy, OperationProvider<TransactionSignature, Void, Boolean, ?, SignatureType> provider) {
        super(workItems, shouldCopy, provider);
    }

    @Override
    protected void handleWorkItem(OperationProvider<TransactionSignature, Void, Boolean, ?, SignatureType> provider, TransactionSignature item) throws NoSuchAlgorithmException {
        item.setFuture(this);
        boolean isValid = provider.compute(item, item.getSignatureType());
        item.setSignatureStatus(isValid ? VerificationStatus.VALID : VerificationStatus.INVALID);
    }
}

