/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.formatting;

import com.swirlds.common.formatting.StringFormattingUtils;
import com.swirlds.common.formatting.TextEffect;
import edu.umd.cs.findbugs.annotations.NonNull;

public enum HorizontalAlignment {
    ALIGNED_LEFT,
    ALIGNED_RIGHT,
    ALIGNED_CENTER;


    @NonNull
    public String pad(@NonNull String text, char padding, int width, boolean trailingPadding) {
        StringBuilder sb = new StringBuilder();
        this.pad(sb, text, padding, width, trailingPadding);
        return sb.toString();
    }

    public void pad(@NonNull StringBuilder sb, @NonNull String text, char padding, int width, boolean trailingPadding) {
        int textLength = TextEffect.getPrintableTextLength(text);
        if (textLength >= width) {
            sb.append(text);
            return;
        }
        switch (this) {
            case ALIGNED_LEFT: {
                sb.append(text);
                if (!trailingPadding) break;
                sb.append(StringFormattingUtils.repeatedChar(padding, width - textLength));
                break;
            }
            case ALIGNED_RIGHT: {
                sb.append(StringFormattingUtils.repeatedChar(padding, width - textLength)).append(text);
                break;
            }
            case ALIGNED_CENTER: {
                int leftPadding = (width - textLength) / 2;
                sb.append(StringFormattingUtils.repeatedChar(padding, leftPadding)).append(text);
                if (!trailingPadding) break;
                int rightPadding = width - textLength - leftPadding;
                sb.append(StringFormattingUtils.repeatedChar(padding, rightPadding));
            }
        }
    }
}

