/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.internal;

import java.security.MessageDigest;
import java.time.Instant;

public abstract class HashUtils {
    public static void update(MessageDigest digest, long n) {
        for (int i = 0; i < 8; ++i) {
            digest.update((byte)(n & 0xFFL));
            n >>= 8;
        }
    }

    public static void update(MessageDigest digest, int n) {
        for (int i = 0; i < 4; ++i) {
            digest.update((byte)(n & 0xFF));
            n >>= 8;
        }
    }

    public static void update(MessageDigest digest, byte[] t, int offset, int length) {
        if (t == null) {
            HashUtils.update(digest, 0);
        } else {
            HashUtils.update(digest, t.length);
            digest.update(t, offset, length);
        }
    }

    public static void update(MessageDigest digest, Instant i) {
        HashUtils.update(digest, i.getEpochSecond());
        HashUtils.update(digest, i.getNano());
    }

    public static void update(MessageDigest digest, byte[][] t) {
        if (t == null) {
            HashUtils.update(digest, 0);
        } else {
            HashUtils.update(digest, t.length);
            for (byte[] a : t) {
                if (a == null) {
                    HashUtils.update(digest, 0);
                    continue;
                }
                HashUtils.update(digest, a.length);
                digest.update(a);
            }
        }
    }

    public static void update(MessageDigest digest, byte[] t) {
        if (t == null) {
            HashUtils.update(digest, 0);
        } else {
            HashUtils.update(digest, t.length);
            digest.update(t);
        }
    }
}

