/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.io.extendable.extensions;

import com.swirlds.common.io.extendable.InputStreamExtension;
import com.swirlds.common.io.extendable.OutputStreamExtension;
import com.swirlds.common.io.extendable.extensions.internal.StreamTimeoutManager;
import com.swirlds.common.utility.CompareTo;
import com.swirlds.logging.LogMarker;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TimeoutStreamExtension
implements InputStreamExtension,
OutputStreamExtension {
    private static final Logger logger = LogManager.getLogger(TimeoutStreamExtension.class);
    private final Duration timeoutPeriod;
    private final AtomicLong operationStartNumber = new AtomicLong();
    private final AtomicLong operationFinishNumber = new AtomicLong();
    private long lastTimeoutCheck = -1L;
    private Instant watchStart;
    private InputStream inputStream;
    private OutputStream outputStream;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    @Override
    public void init(InputStream baseStream) {
        this.inputStream = baseStream;
    }

    @Override
    public void init(OutputStream baseStream) {
        this.outputStream = baseStream;
    }

    public static TimeoutStreamExtension buildTimeoutStreamExtension(Duration timeoutPeriod) {
        TimeoutStreamExtension extension = new TimeoutStreamExtension(timeoutPeriod);
        StreamTimeoutManager.register(extension);
        return extension;
    }

    private TimeoutStreamExtension(Duration timeoutPeriod) {
        this.timeoutPeriod = timeoutPeriod;
    }

    @Override
    public void close() {
        this.closed.getAndSet(true);
    }

    public boolean checkTimeout() {
        if (this.closed.get()) {
            return false;
        }
        long finishNumber = this.operationFinishNumber.get();
        long startNumber = this.operationStartNumber.get();
        if (this.lastTimeoutCheck == startNumber && finishNumber < startNumber) {
            if (this.watchStart == null) {
                this.watchStart = Instant.now();
            } else {
                Duration elapsedTime = Duration.between(this.watchStart, Instant.now());
                if (CompareTo.isGreaterThan(elapsedTime, this.timeoutPeriod)) {
                    this.triggerTimeout();
                }
            }
        } else {
            this.lastTimeoutCheck = this.operationStartNumber.get();
            this.watchStart = null;
        }
        return true;
    }

    private void triggerTimeout() {
        logger.error(LogMarker.EXCEPTION.getMarker(), "operation timed out on stream");
        this.close();
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (IOException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "exception while attempting to close timed out stream", (Throwable)e);
        }
    }

    @Override
    public int read() throws IOException {
        long op = this.operationStartNumber.incrementAndGet();
        int aByte = this.inputStream.read();
        this.operationFinishNumber.set(op);
        return aByte;
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        long op = this.operationStartNumber.incrementAndGet();
        int count = this.inputStream.read(bytes, offset, length);
        this.operationFinishNumber.set(op);
        return count;
    }

    @Override
    public byte[] readNBytes(int length) throws IOException {
        long op = this.operationStartNumber.incrementAndGet();
        byte[] data = this.inputStream.readNBytes(length);
        this.operationFinishNumber.set(op);
        return data;
    }

    @Override
    public int readNBytes(byte[] bytes, int offset, int length) throws IOException {
        long op = this.operationStartNumber.incrementAndGet();
        int count = this.inputStream.readNBytes(bytes, offset, length);
        this.operationFinishNumber.set(op);
        return count;
    }

    @Override
    public void write(int b) throws IOException {
        long op = this.operationStartNumber.incrementAndGet();
        this.outputStream.write(b);
        this.operationFinishNumber.set(op);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        long op = this.operationStartNumber.incrementAndGet();
        this.outputStream.write(bytes, offset, length);
        this.operationFinishNumber.set(op);
    }
}

