/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.io.extendable.extensions.internal;

import com.swirlds.common.io.extendable.extensions.TimeoutStreamExtension;
import com.swirlds.common.threading.framework.StoppableThread;
import com.swirlds.common.threading.framework.config.StoppableThreadConfiguration;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class StreamTimeoutManager {
    private static final double RATE = 10.0;
    private static final Queue<TimeoutStreamExtension> extensions = new ConcurrentLinkedQueue<TimeoutStreamExtension>();
    private static boolean started = false;
    private static final StoppableThread thread = ((StoppableThreadConfiguration)((StoppableThreadConfiguration)((StoppableThreadConfiguration)((StoppableThreadConfiguration)new StoppableThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setComponent("timeout-extension")).setThreadName("manager")).setMaximumRate(10.0)).setWork(StreamTimeoutManager::doWork)).build();

    private StreamTimeoutManager() {
    }

    private static void doWork() {
        for (TimeoutStreamExtension extension : extensions) {
            if (extension.checkTimeout()) continue;
            StreamTimeoutManager.deregister(extension);
        }
    }

    private static synchronized void start() {
        if (!started) {
            thread.start();
            started = true;
        }
    }

    public static void register(TimeoutStreamExtension extension) {
        StreamTimeoutManager.start();
        extensions.add(extension);
    }

    private static void deregister(TimeoutStreamExtension extension) {
        Iterator iterator = extensions.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != extension) continue;
            iterator.remove();
            return;
        }
    }

    public static int getMonitoredStreamCount() {
        return extensions.size();
    }
}

